#include <iostream>
using namespace std;

const int m = 1000000007;

typedef int matrix[5][5];
typedef int vec[5];

void matrix_assign(matrix a, matrix o) {
    for (int x=0; x<5; ++x) {
        for (int y=0; y<5; ++y) {
            o[x][y] = a[x][y];
        }
    }
}

void vec_assign(vec a, vec o) {
    for (int x=0; x<5; ++x) {
        o[x] = a[x];
    }
}

void matrix_add(matrix a, matrix b, matrix o) {
    for (int x=0; x<5; ++x) {
        for (int y=0; y<5; ++y) {
            o[x][y] = a[x][y] + b[x][y];
        }
    }
}

void matrix_mul(matrix a, matrix b, matrix o) {
    for (int x=0; x<5; ++x) {
        for (int y=0; y<5; ++y) {
            int res = 0;
            for (int i=0; i<5; ++i) {
                res += a[x][i] * b[i][y];
            }
            o[x][y] = res;
        }
    }
}

void matrix_mul_vec(matrix a, vec b, vec o) {
    for (int x=0; x<5; ++x) {
        int res = 0;
        for (int i=0; i<5; ++i) {
            res += a[x][i] * b[i];
        }
        o[x] = res;
    }
}

void matrix_mod(int m, matrix o) {
    for (int x=0; x<5; ++x) {
        for (int y=0; y<5; ++y) {
            o[x][y] = o[x][y] % m;
        }
    }
}

matrix zero =
    {{0,0,0,0,0}
    ,{0,0,0,0,0}
    ,{0,0,0,0,0}
    ,{0,0,0,0,0}
    ,{0,0,0,0,0}};

matrix one =
    {{1,0,0,0,0}
    ,{0,1,0,0,0}
    ,{0,0,1,0,0}
    ,{0,0,0,1,0}
    ,{0,0,0,0,1}};

void binary_exponentiation(matrix a_in, int e, int m, matrix o) {
    matrix temp1;
    matrix temp2;

    matrix a;
    matrix_assign(a_in, a);
    matrix_assign(one, o);
    while (e) {
        //cout << "E LOOP: " << e << endl;
        if (e & 1) {
            matrix_mul(a, o, temp1);
            matrix_assign(temp1, o);
            matrix_mod(m, o);
        }
        matrix_mul(a, a, temp1);
        matrix_assign(temp1, a);
        matrix_mod(m, a);
        e /= 2;
    }
}

int main() {
    int n, t;
    cin >> n >> t;
    vec s;
    matrix p;

    if (t==1) {
        vec ss = {1,1,2,0,0};
        matrix pp =
            {{0,1,0,0,0}
            ,{0,0,1,0,0}
            ,{0,1,1,0,0}
            ,{0,0,0,0,0}
            ,{0,0,0,0,0}};
        vec_assign(ss, s);
        matrix_assign(pp, p);
    } else if (t == 2) {
        n--;
        vec ss = {0,0,2,0,0};
        // something is wrong here
        matrix pp =
            {{0,1,0,0,0}
            ,{0,0,1,0,0}
            ,{0,0,0,1,1}
            ,{0,1,0,0,0}
            ,{0,1,0,0,0}};
        vec_assign(ss, s);
        matrix_assign(pp, p);
    } else if (t == 3) {
        vec ss = {1,1,2,1,1};
        matrix pp =
            {{0,1,0,0,0}
            ,{0,0,1,0,0}
            ,{0,1,1,1,1}
            ,{0,1,0,0,1}
            ,{0,1,0,1,0}};
        vec_assign(ss, s);
        matrix_assign(pp, p);
    }
    matrix o;
    binary_exponentiation(p, n, m, o);

    /*
    for (int x=0; x<5; ++x) {
        for (int y=0; y<5; ++y) {
            cout << o[x][y] << " ";
        }
        cout << endl;
    }
    */

    vec oo;
    matrix_mul_vec(o, s, oo);
    int res = oo[0];
    cout << res;
}
