#include<iostream>
#include<list>
#include<vector>

#define INF 100001

using namespace std;

class Graph {

    int V;
    list<int> *adj;

public:

    Graph(int V);

    void addEdge(int u, int w);

    vector<int> getDistances(int s);

};

Graph::Graph(int V) {

    this->V = V;
    adj = new list<int>[V];

}

void Graph::addEdge(int u, int w) {

    adj[u].push_back(w);
    adj[w].push_back(u);

}

vector<int> Graph::getDistances(int s) {

    vector<int> dist(V, INF);
    dist[s] = 0;

    list<int> queue;
    queue.push_back(s);

    list<int>::iterator it;

    while (!queue.empty()) {

        s = queue.front();
        queue.pop_front();

        for (it = adj[s].begin();it != adj[s].end();++it) {

            int newDist = dist[s] + 1;

            if (newDist < dist[*it]) {

                dist[*it] = newDist;
                queue.push_back(*it);

            }

        }

    }

    vector<int> returnDist(V-1, 0);

    for (int i=1;i<V;++i) {

        returnDist[i-1] = dist[i];

    }

    return returnDist;

}

int n, a, b, ans = 0;
vector<vector<int>> allD;

int main() {

    cin >> n;

    Graph g(n+1);

    for (int i=0;i<n-1;++i) {

        cin >> a >> b;
        g.addEdge(a, b);

    }

    for (int i=1;i<=n;++i)
        allD.push_back(g.getDistances(i));

    for (int i=0;i<n-1;++i) {

        for (int j=i+1;j<n;++j) {

            if (allD[i][j] > 1) {

                for (int kk=j+1;kk<n;++kk) {

                    if (allD[j][kk] > 1 && allD[i][kk] > 1)
                        ans++;

                }

            }

        }

    }

    cout << ans;

    return 0;

}
