#include<iostream>
#define ull unsigned long long
#define MOD 1000000007

using namespace std;

ull fastPowMod(ull pow) {
    ull res = 1;
    ull base = 2;
    while(pow != 0) {
        if(pow % 1 == 1) {
            res *= base;
            res = res % MOD;
        }
        pow >>= 1;
        base = (base * base) % MOD;
    }
    return res;
}
ull fib(ull n) {
    ull prev1 = 1;
    ull prev2 = 2;
    if (n < 3) {
        return n;
    }
    ull res;
    for(ull i = 0; i < n - 2; i++) {
        res = prev1 + prev2;
        if (res >= MOD) {
            res = res - MOD; /// valid bcs prev1<MOD && prev2<MOD
        }
        prev1 = prev2;
        prev2 = res;
    }
    return res;
}

ull solve3(ull r) {
    if(r == 1) {
        return 1;
    }
    if(r == 2) {
        return 2;
    }
    if(r == 3) {
        return 5;
    }
    // n = 4
    ull double_sum = 4; /// 2*(f(n-3) + f(n-4) ...)
    ull f_n = 0;
    ull f_n_minus_1 = 5;
    ull f_n_minus_2 = 2;
    for(ull i = 0; i < r - 3; i++) {
        f_n = f_n_minus_1 + f_n_minus_2 + double_sum;
        f_n = f_n % MOD;
        double_sum += 2*f_n_minus_2;
        double_sum = double_sum % MOD;
        f_n_minus_2 = f_n_minus_1;
        f_n_minus_1 = f_n;
    }
    return f_n;
}

int main() {
    ull n;
    int t;
    cin>>n>>t;
    if(t==1) {
        cout<<fib(n)<<endl;
        return 0;
    }
    if(t == 2) {
        if(n % 3 != 0) {
            cout<<0<<endl;
            return 0;
        }
        ull res = fastPowMod(n/3);
        cout<<res<<endl;
        return 0;
    }
    cout<<solve3(n % MOD)<<endl;
}
