#include <iostream>
#include <cmath>
#include <numeric>
#include <string.h>

using u64 = unsigned long long;
using u32 = unsigned int;
using s64 = long long;
using s32 = int;


u64 mod = 1000000000 + 7;
// u32 mod = 2;

u64 calc_just_i_rec(u64 n) {
    if (n < 0) return 0;
    if (n == 1) return 1;
    if (n == 2) return 2;

    return calc_just_i_rec(n - 1) + calc_just_i_rec(n - 2); // Fibonacci...
}

u64 calc_just_l_rec(u64 n) {
    if (n % 3 != 0) return 0;

    if (n < 1) return 0;
    if (n == 3) return 2;
    if (n == 6) return 4;

    return calc_just_l_rec(n - 3) + calc_just_l_rec(n - 6); // Fibonacci...
}

u64 calc_just_i_it(u64 n) {
    if (n < 1) return 0;
    if (n == 1) return 1;
    if (n == 2) return 2;

    n -= 2;

    u32 a = 1, b = 2;
    while (n--) {
        u32 c = (a % mod + b % mod) % mod;
        a = b;
        b = c;
    }
    return b;
}

u64 calc_just_mixed_rec(u64 n) {
    if (n < 4) return 0;
    if (n == 4) return 2;
    if (n == 8) return 4;
    if (n % 4 != 0) return 0;

    return calc_just_mixed_rec(n - 4) + calc_just_mixed_rec(n - 8);
}

u64 calc_both(u64 n) {
    if (n < 1) return 0;
    if (n <= 8) return calc_just_i_rec(n) + calc_just_l_rec(n) + calc_just_mixed_rec(n);

    return calc_both(n - 1) + calc_both(n - 2) + calc_both(n - 3) + calc_both(n - 4) + calc_both(n - 5) + calc_both(n - 6) + calc_both(n - 7) + calc_both(n - 8);
}

int main() {
    u64 N, T;

    std::cin >> N >> T;
    //while (std::cin >> N >> T) {

        if (T == 1) {
            std::cout << calc_just_i_rec(N);
        } else if (T == 2) {
            std::cout << calc_just_l_rec(N);
        } else {
            std::cout << calc_both(N);
        }
    //    std::cout << "\n\n";
    //}

    //while (std::cin >> N) {
    //    std::cout << calc_just_l_rec(N) << "\n\n";
    //}

    //for (int i = 2; i < 100; ++i) {
    //    std::cout << "It: " << calc_just_i_it(i) << "\n";

    //    double phi = (1.0 - std::sqrt(5)) / 2;
    //    std::cout << "Po: " << std::pow(phi, (double) i) - 1 << "\n";
    //}

    //for (u64 i = 0; i < mod / 2; i++) {
    //    if (mod % i == 0) {
    //        std::cout << i << " divides " << mod << "\n";
    //    }
    //}

    //while (std::cin >> N >> T) {
     //   if (T == 1) {
     //       std::cout << "It: " << calc_just_i_it(N) << ", dire: " << calc_just_i_dire(N) << "\n\n";
     //   } else {
     //       std::cout << "Oops\n";
     //   }
   // }
}




