#include <bits/stdc++.h>
using namespace std;


const int MOD = 1000000007;

int power(int x, int n) {
    if (n == 0) return 1;
    int output = x;
    while (n != 1) {
        output = (output*x)%MOD;
        n--;
    }
    return output;
}

int dp1(int n, vector<int> vec) {
    if (n == 1) return vec[0];
    if (n == 2) return vec[1];
    for (int i = 2, curr; i < n; i++) {
        curr = (vec[i - 1] + vec[i - 2])%MOD;
        vec.push_back(curr);
    }
    return vec.back();
}

int calc2(int n) {
    if (n % 3 != 0) return 0;
    return power(2, n/3);
}

int dp3(int n, vector<int> vec) {
    if (n == 1) return vec[0];
    if (n == 2) return vec[1];
    for (int i = 2, curr; i < n; i++) {
        curr = (vec[i - 1] + vec[i - 2] + power(2, i - 1))%MOD;
        vec.push_back(curr);
    }
    return vec.back();
}

int main() {
    ios::sync_with_stdio(0);
    cin.tie(0);

    int N, T;
    cin >> N >> T;

    vector<int> dp;
    dp.push_back(1);
    dp.push_back(2);

    switch (T) {
    case 1:
        cout << dp1(N, dp) << '\n';
        break;
    case 2:
        cout << calc2(N) << '\n';
        break;
    case 3:
        cout << dp3(N, dp) << '\n';
        break;
    }

    return 0;
}
