#include<iostream>
#include<vector>

using namespace std;

const int maxn = 30005;
int desc[maxn]; /// descendant
bool used[maxn];
vector< vector<int> > allCycles;
pair<int,int> posInfo[maxn]; /// position

//long long mlt(long long a, long long b){
//    long long result = 0;
//    for(int i=0; i<b; i++){
//        result += a;
//    }
//    return result;
//}

long long perc(long long a, long long b){
    long long result = a;
    while(result-b > 0){
        result -= b;
    }
    return result;
}

int main(){
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    long long n, m;
    cin >> n >> m;

    for(int i=1; i<=n; i++){
        cin >> desc[i];
    }

    for(int i=1; i<=n; i++){
        int currPos = i;
        if(used[currPos] == 1) continue;

        vector<int> currCycle;

        while(used[currPos] == 0){
            currCycle.push_back(currPos);
            posInfo[currPos] = make_pair(allCycles.size(), currCycle.size()-1);

            used[currPos] = true;
            currPos = desc[currPos];
        }

        allCycles.push_back(currCycle);
    }

//    cout << "--------" << endl;
//
//    for(int i=0; i<allCycles.size(); i++){
//        for(int j=0; j<allCycles[i].size(); j++){
//            cout << allCycles[i][j] << " ";
//        }
//        cout << endl;
//    }
//
//     cout << "--------" << endl;

    for(int i=1; i<=n; i++){
        int currPosInAllCylces = posInfo[i].first;
        int currPosInCycle = posInfo[i].second;
        int currCycleSize = allCycles[currPosInAllCylces].size();

        long long newPosInCycle = perc((currPosInCycle + m), currCycleSize);

        cout << allCycles[currPosInAllCylces][newPosInCycle];
        if(i!=n) cout << " ";
    }

    cout << endl;

    return 0;
}

/*
5 2
3 1 5 4 2
*/

/*
14 5
2 3 5 6 7 10 9 4 1 8 13 12 14 11
*/
