#include <bits/stdc++.h>
#define MAXN 50'005
#define MAX_LIFT 20

struct Edge {
    int to;
    int next;
};

int first_edge[MAXN];
Edge edges[MAXN];
int edges_l = 0;

void make_edge(int from, int to) {
    edges[edges_l] = {to, first_edge[from]};
    first_edge[from] = edges_l;
    edges_l++;
}

void make_double_edge(int u, int v) {
    make_edge(u, v);
    make_edge(v, u);
}

int n, k;

int p[MAXN];
int used[MAXN];

void bfs(int from) {
    std::queue<int> q;
    q.push(from);
    while(!q.empty()) {
        int root = q.front();
        //std::cout << root << std::endl;
        q.pop();
        for (int e = first_edge[root]; e != -1; e = edges[e].next) {
            if (p[edges[e].to]) continue;
            p[edges[e].to] = root;
            q.push(edges[e].to);
        }
    }
}

int main() {
    std::ios_base::sync_with_stdio(0);
    std::cin.tie(0);
    std::cout.tie(0);
    std::cin >> n >> k;
    for (int i = 0; i <= n; i++) first_edge[i] = -1;
    for (int i = 0; i < n - 1; i++) {
        int u, v;
        std::cin >> u >> v;
        make_double_edge(u, v);
    }
    for (int i = 0; i < k; i++) {
        int u, v, w;
        std::cin >> u >> v;
        for (int i = 1; i <= n; i++) p[i] = 0;
        bfs(u);
        for (int w = v; w != u; w = p[w]) used[w]++;
        used[u]++;
    }
    int ans = 0;
    for (int i = 1; i <= n; i++) ans = std::max(ans, used[i]);
    std::cout << ans << std::endl;
}
