#include <bits/stdc++.h>
#define MAXN 50'005
#define MAX_LIFT 20

struct Edge {
    int to;
    int next;
};

int first_edge[MAXN];
Edge edges[MAXN];
int edges_l = 0;

void make_edge(int from, int to) {
    edges[edges_l] = {to, first_edge[from]};
    first_edge[from] = edges_l;
    edges_l++;
}

void make_double_edge(int u, int v) {
    make_edge(u, v);
    make_edge(v, u);
}

int n, k;
int used[MAXN];

int dfs(int root, int to, int p) {
    if (root == to) {
        used[root]++;
        return 1;
    }
    for (int e = first_edge[root]; e != -1; e = edges[e].next) {
        if (edges[e].to == p) continue;
        if (dfs(edges[e].to, to, root)) {
            used[root]++;
            return 1;
        }
    }
}
int main() {
    std::ios_base::sync_with_stdio(0);
    std::cin.tie(0);
    std::cout.tie(0);
    std::cin >> n >> k;
    for (int i = 0; i <= n; i++) first_edge[i] = -1;
    for (int i = 0; i < n - 1; i++) {
        int u, v;
        std::cin >> u >> v;
        make_double_edge(u, v);
    }
    for (int i = 0; i < k; i++) {
        int u, v, w;
        std::cin >> u >> v;
        dfs(u, v, 0);
    }
    int ans = 0;
    for (int i = 1; i <= n; i++) ans = std::max(ans, used[i]);
    std::cout << ans;

}

