#include <bits/stdc++.h>
#define MAXN 50'005
#define MAX_LIFT 20

struct Edge {
    int to;
    int next;
};

int first_edge[MAXN];
Edge edges[MAXN];
int edges_l = 0;

void make_edge(int from, int to) {
    edges[edges_l] = {to, first_edge[from]};
    first_edge[from] = edges_l;
    edges_l++;
}

void make_double_edge(int u, int v) {
    make_edge(u, v);
    make_edge(v, u);
}

int n, k;

int depth[MAXN];
int lift[MAXN][MAX_LIFT + 1];
int start_at[MAXN];
int end_at[MAXN];
int used[MAXN];

void precalc(int root, int p) {
    lift[root][0] = p;
    for (int i = 1; i <= MAX_LIFT; i++) lift[root][i] = lift[lift[root][i - 1]][i - 1];
    depth[root] = depth[p] + 1;

    for (int e = first_edge[root]; e != -1; e = edges[e].next) {
        if (edges[e].to == p) continue;
        precalc(edges[e].to, root);
    }
}

int lift_with(int u, int with) {
    if (with == 0) return u;
    int i = MAX_LIFT;
    while ((1 << i) > with) i--;
    //std::cout << u << " with lift " << i << " is " << lift[u][i] << std::endl;
    u = lift[u][i];
    return lift_with(u, with - (1 << i));
}

int lca(int u, int v) {
    if (depth[u] > depth[v]) u = lift_with(u, depth[u] - depth[v]);
    if (depth[v] > depth[u]) v = lift_with(v, depth[v] - depth[u]);
    //std::cout << "eq: " << u << ' ' << v << std::endl;
    int l = 0, r = depth[u];
    if (u == v) return u;
    for (int i = MAX_LIFT; i >= 0; i--) {
        int lifted_u = lift[u][i], lifted_v = lift[v][i];
        //std::cout << u << ' ' << v << ' ' << lifted_u << ' ' << lifted_v << std::endl;
        if (lifted_u != lifted_v) {
            u = lifted_u;
            v = lifted_v;
        }
    }
    //std::cout << u << ' ' << v << std::endl;
    return lift[u][0];
}

void calc_used(int root, int coming) {
    //std::cout << root << ' ' << coming << ' ' << start_at[root] << ' ' << end_at[root] << std::endl;;
    coming += start_at[root];
    used[root] = coming;
    coming -= end_at[root];
    for (int e = first_edge[root]; e != -1; e = edges[e].next) {
        if (edges[e].to == lift[root][0]) continue;
        calc_used(edges[e].to, coming);
    }
}

int main() {
    std::ios_base::sync_with_stdio(0);
    std::cin.tie(0);
    std::cout.tie(0);
    std::cin >> n >> k;
    for (int i = 0; i <= n; i++) first_edge[i] = -1;
    for (int i = 0; i < n - 1; i++) {
        int u, v;
        std::cin >> u >> v;
        make_double_edge(u, v);
    }
    precalc(1, 0);
    for (int i = 0; i < k; i++) {
        int u, v, w;
        std::cin >> u >> v;
        w = lca(u, v);
        //std::cout << w  << std::endl;
        start_at[w]++;
        if (u != w) end_at[u]++;
        if (v != w) end_at[v]++;
        if (u == v) end_at[w]++;
    }
    calc_used(1, 0);
    int ans = 0;
    for (int i = 1; i <= n; i++) {
        //std::cout << used[i] << std::endl;
        ans = std::max(ans, used[i]);
    }
    std::cout << ans << std::endl;
}

