#include<iostream>
#include<vector>
#include<queue>
using namespace std;

int broiGradove;
int broiEkskurzii;

vector<int> sasedstvo[50010];

int broiPutiSreshtaneNaTozi[50010];

int parents[50010];
bool visited[50010];

void bfs(int start, int finaal){
    for(int i = 0; i <= broiGradove; i++){
        visited[i] = false;
    }

    queue<int> q;
    q.push(start);
    parents[start] = -1;

    while(q.empty() == false){
        int naiOtprerd = q.front();
        q.pop();

        if(visited[naiOtprerd] == true){
            continue;
        }

        visited[naiOtprerd] = true;

        if(naiOtprerd == finaal){
            break;
        }

        for(unsigned int i = 0; i < sasedstvo[naiOtprerd].size(); i++){
            if(visited[sasedstvo[naiOtprerd][i]] == false){
                q.push(sasedstvo[naiOtprerd][i]);
                parents[sasedstvo[naiOtprerd][i]] = naiOtprerd;
            }
        }

    }

}

int dfs(int segashen, int otKadeIdvame, int koiTarsime){
    if(segashen == koiTarsime){
        broiPutiSreshtaneNaTozi[segashen]++;
        return 1;
    }

    int zaVrasht = -1;

    for(unsigned i = 0; i < sasedstvo[segashen].size(); i++){
        if(sasedstvo[segashen][i] != otKadeIdvame){
            int zaTuk = dfs(sasedstvo[segashen][i], segashen, koiTarsime);

            if(zaTuk != -1){
                zaVrasht = zaTuk;
                break;
            }
        }
    }

    if(zaVrasht == 1){
        broiPutiSreshtaneNaTozi[segashen]++;
    }

    return zaVrasht;
}

int main(){
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    cout.tie(NULL);

    cin>>broiGradove>>broiEkskurzii;

    for(int i = 0; i < broiGradove - 1; i++){
        int otKade;
        int doKade;

        cin>>otKade>>doKade;

        sasedstvo[otKade].push_back(doKade);
        sasedstvo[doKade].push_back(otKade);
    }

    for(int i = 0; i < broiEkskurzii; i++){
        int otKade;
        int doKade;

        cin>>otKade>>doKade;

        //dfs(otKade, -1, doKade);

        bfs(otKade, doKade);

        for(int v = doKade; v != -1; v = parents[v]){
            broiPutiSreshtaneNaTozi[v]++;
        }

    }

    int broiPutiNaiPoseshtavan = 0;

    for(int i = 1; i <= broiGradove; i++){
        if(broiPutiSreshtaneNaTozi[i] > broiPutiNaiPoseshtavan){
            broiPutiNaiPoseshtavan = broiPutiSreshtaneNaTozi[i];
        }
    }

    cout<<broiPutiNaiPoseshtavan<<endl;

    return 0;
}

/*

1 4
3 4
4 2
4 5
5 6
6 7
7 9
9 8
10 9*/
