#include <iostream>
#include <queue>


const int MAXN = 2e4;
int sum[MAXN];

struct sub
{
    int l, r, ans;
};

int bins(int l, int r)
{
    if((sum[l] + sum[r]) % 2)
    {
        return -1;
    }

    int searchFor = (sum[l] + sum[r]) / 2;

    while(l < r - 1)
    {
        int mid = (l + r) / 2;
        if(sum[mid] < searchFor)
        {
            l = mid;
        }else
        {
            r = mid;
        }
    }
    return r;
}

int main()
{
    //std::cin.tie(nullptr);
    //std::cout.tie(nullptr);
    //std::ios_base::sync_with_stdio(false);

    int t;
    scanf("%i", &t);

    while(t --)
    {
        int n, answer = 0;
        scanf("%i", &n);
        sum[0] = 0;
        for(int i = 1; i <= n; ++ i)
        {
            int x;
            std::cin >> x;
            sum[i] = sum[i - 1] + x;
        }

        std::queue<sub> q;
        q.push({0, n, 0});
        while(!q.empty())
        {
            auto curr = q.front();
            q.pop();

            int tr = bins(curr.l, curr.r);
            if(tr == -1 || sum[tr] != (sum[curr.l] + sum[curr.r]) / 2)
            {
                continue;
            }
            if(!((sum[curr.l] + sum[tr]) % 2)) q.push({curr.l, tr, curr.ans + 1});
            if(!((sum[tr] + sum[curr.r]) % 2)) q.push({tr, curr.r, curr.ans + 1});
            answer = std::max(answer, curr.ans + 1);

        }
        printf("%i\n", answer);
    }

    return 0;
}
