#include <iostream>
#include <algorithm>
using namespace std;
const int MAXN=5e5+10;
struct interval {
    int l, r, c;
};
interval a[MAXN];
int tree[4*MAXN], lazy[4*MAXN];
int str[MAXN], cert[MAXN], pr[MAXN];
int n, k;
bool cmp(interval a, interval b) {
    if (a.c!=b.c) return a.c<b.c;
    if (a.l!=b.l) return a.l<b.l;
    return a.r<b.r;
}
bool cmp1(interval a, interval b) {
    if (a.c!=b.c) return a.c>b.c;
    if (a.l!=b.l) return a.l>b.l;
    return a.r>b.r;
}
void build_tree(int node, int l, int r) {
    lazy[node]=0;
    if (l==r) {
        tree[node]=1;
        return;
    }
    int mid=(l+r)/2;
    build_tree(node*2,l,mid);
    build_tree(node*2+1,mid+1,r);
    tree[node]=tree[node*2]+tree[node*2+1];
}
void push_lazy(int node, int l, int r) {
    if (lazy[node]==0) return;
    if (l!=r) {
        lazy[node*2]+=lazy[node];
        tree[node*2]=0;
        lazy[node*2+1]+=lazy[node];
        tree[node*2+1]=0;
    }
    lazy[node]=0;
}
void update(int node, int l, int r, int ql, int qr) {
    if (ql>r || qr<l) return;
    push_lazy(node,l,r);
    if (l>=ql && r<=qr) {
        lazy[node]++;
        tree[node]=0;
        return;
    }
    int mid=(l+r)/2;
    update(node*2,l,mid,ql,qr);
    update(node*2+1,mid+1,r,ql,qr);
    tree[node]=tree[node*2]+tree[node*2+1];
}
int query(int node, int l, int r, int ql, int qr) {
    if (ql>r || qr<l) return 0;
    push_lazy(node,l,r);
    ///cout << tree[node] << ' ' << node << ' ' << l << ' ' << r << ' ' << ql << ' ' << qr << endl;
    if (l>=ql && r<=qr) return tree[node];
    int mid=(l+r)/2;
    return query(node*2,l,mid,ql,qr)+query(node*2+1,mid+1,r,ql,qr);
}
int pref(int l, int r) {
    if (l==0) return pr[r];
    return pr[r]-pr[l-1];
}
bool check() {
    for (int i=0;i<n;i++) {
        if (i==0) pr[i]=str[i];
        else pr[i]=pr[i-1]+str[i];
    }
    int s;
    for (int i=0;i<k;i++) {
        s=pref(a[i].l,a[i].r);
        if (a[i].c==2) {
            if (s==0 || s==a[i].r-a[i].l+1) return false;
        } else {
            if (s!=0 && s!=a[i].r-a[i].l+1) {
                return false;
            }
        }
    }
    return true;
}
int main () {
    cin >> n >> k;
    bool ok1=true, ok2=true;
    for (int i=0;i<k;i++) {
        cin >> a[i].l >> a[i].r >> a[i].c;
        if (a[i].c==2) ok1=false;
        if (a[i].c==1) ok2=false;

    }
    for (int i=0;i<n;i++) {
        if (a[i].c==2 && a[i].l==a[i].r) {
            cout << 0 << endl;
            return 0;
        }
    }
    if (!ok2 && ok1) {
        cout << 1 << endl;
        for (int i=0;i<n;i++) cout << 'G';
        cout << endl;
        return 0;
    } else if (!ok1 && ok2) {
        cout << 1 << endl;
        for (int i=0;i<n;i++) {
            if (i%2==0) cout << 'G';
            else cout << 'Y';
        }
        cout << endl;
        return 0;
    }
    /**
    if (n<=18) {
        int br, ki;
        for (int i=0;i<(1<<n);i++) {
            ki=i;
            br=0;
            while (ki>0) {
                str[br]=ki%2;
                ki/=2;
                br++;
            }
            if (check()) {
                cout << 1 << endl;
                for (int i=0;i<n;i++) {
                    if (str[i]==0) cout << 'G';
                    else cout << 'Y';
                }
                cout << endl;
                return 0;
            }
        }
        cout << 0 << endl;
        return 0;
    }
    **/
    sort(a,a+k,cmp);
    bool ok=true;
    int sum;
    build_tree(1,0,n-1);
    for (int i=0;i<k;i++) {
        if (a[i].c==1) update(1,0,n-1,a[i].l,a[i].r);
        else {
            sum=query(1,0,n-1,a[i].l,a[i].r);
            if (sum==0) ok=false;
        }
    }
    if (!ok) {
        cout << 0 << endl;
        return 0;
    }
    for (int i=0;i<n;i++) {
        if (query(1,0,n-1,i,i)==0) {
            str[i]=0;
            cert[i]=1;
        } else {
            str[i]=1;
            cert[i]=0;
        }
    }
    for (int i=0;i<k;i++) {
        if (a[i].c==1 || a[i].r-a[i].l+1!=2) continue;
        if (str[a[i].l]==str[a[i].r]) {
            if (cert[a[i].l] && cert[a[i].r]) ok=false;
            if (cert[a[i].l]) {
                str[a[i].r]=(str[a[i].r]+1)%2;
                cert[a[i].r]=1;
            }
        } else cert[a[i].l]=cert[a[i].r]=1;
    }
    sort(a,a+k,cmp1);
    for (int i=0;i<k;i++) {
        if (a[i].c==1) break;
        if (str[a[i].l]==str[a[i].r]) {
            if (cert[a[i].l] && cert[a[i].r]) ok=false;
            if (cert[a[i].r]) {
                str[a[i].l]=(str[a[i].l]+1)%2;
                cert[a[i].l]=1;
            }
        } else cert[a[i].l]=cert[a[i].r]=1;
    }
    if (!ok) {
        cout << 0 << endl;
        return 0;
    }
    cout << 1 << endl;
    int br=1;
    for (int i=0;i<n;i++) {
        if (cert[i]==0) str[i]=br%2;
        if (cert[i]==1) br=1;
    }
    for (int i=0;i<n;i++) {
        if (str[i]==0) cout << 'G';
        else cout << 'Y';
    }
    return 0;
}
/**
9 7
0 1 1
7 8 1
1 2 2
2 3 2
3 4 2
5 6 2
6 7 2

8
**/
