#include <iostream>
#include <algorithm>
using namespace std;
const int MAXN=5e5+10;
struct interval {
    int l, r, c;
};
interval a[MAXN];
int tree[4*MAXN], lazy[4*MAXN];
string str;
bool cmp(interval a, interval b) {
    return a.c<b.c;
}
void build_tree(int node, int l, int r) {
    lazy[node]=0;
    if (l==r) {
        tree[node]=1;
        return;
    }
    int mid=(l+r)/2;
    build_tree(node*2,l,mid);
    build_tree(node*2+1,mid+1,r);
    tree[node]=tree[node*2]+tree[node*2+1];
}
void push_lazy(int node, int l, int r) {
    if (lazy[node]==0) return;
    if (l!=r) {
        lazy[node*2]+=lazy[node];
        tree[node*2]=0;
        lazy[node*2+1]+=lazy[node];
        tree[node*2+1]=0;
    }
    lazy[node]=0;
}
void update(int node, int l, int r, int ql, int qr) {
    if (ql>r || qr<l) return;
    push_lazy(node,l,r);
    if (l>=ql && r<=qr) {
        lazy[node]++;
        tree[node]=0;
        return;
    }
    int mid=(l+r)/2;
    update(node*2,l,mid,ql,qr);
    update(node*2+1,mid+1,r,ql,qr);
    tree[node]=tree[node*2]+tree[node*2+1];
}
int query(int node, int l, int r, int ql, int qr) {
    if (ql>r || qr<l) return 0;
    push_lazy(node,l,r);
    ///cout << tree[node] << ' ' << node << ' ' << l << ' ' << r << ' ' << ql << ' ' << qr << endl;
    if (l>=ql && r<=qr) return tree[node];
    int mid=(l+r)/2;
    return query(node*2,l,mid,ql,qr)+query(node*2+1,mid+1,r,ql,qr);
}
int main () {
    int n, k;
    cin >> n >> k;
    bool ok=true;
    for (int i=0;i<k;i++) {
        cin >> a[i].l >> a[i].r >> a[i].c;
        if (a[i].c==2) ok=false;

    }
    for (int i=0;i<n;i++) {
        if (a[i].c==2 && a[i].l==a[i].r) {
            cout << 0 << endl;
            return 0;
        }
    }
    if (ok) {
        cout << 1 << endl;
        for (int i=0;i<n;i++) cout << 'G';
        cout << endl;
        return 0;
    } else {
        cout << 1 << endl;
        for (int i=0;i<n;i++) {
            if (i%2==0) cout << 'G';
            else cout << 'Y';
        }
        cout << endl;
        return 0;
    }
    sort(a,a+k,cmp);
    ok=true;
    int sum;
    build_tree(1,0,n-1);
    for (int i=0;i<k;i++) {
        if (a[i].c==1) update(1,0,n-1,a[i].l,a[i].r);
        else {
            sum=query(1,0,n-1,a[i].l,a[i].r);
            if (sum==0) ok=false;
        }
    }
    if (!ok) {
        cout << 0 << endl;
        return 0;
    }
    for (int i=0;i<n;i++) {
        if (query(1,0,n-1,i,i)==0) str+='G';
        else str+='Y';
    }
    cout << endl;
    return 0;
}
/**
7 3
0 4 1
2 5 1
5 6 2

7 3
0 4 1
2 6 1
5 6 2
**/
