#include <iostream>
#include <vector>
using namespace std;
const int maxn = 5e4+10, maxlog = 3;
vector < int > v[maxn];
int vis[maxn];
int depth[maxn];
int par[maxn][maxlog];
int n, k;
void init_par(int x, int p = 0, int d = 1) {
    par[x][0] = p;
    depth[x] = d;
    for (int i : v[x])
        if (i != p) init_par(i, x, d+1);
}
int eq(int down, int up) {
    for (int i = maxlog - 1 ; i >= 0 ; --i) {
        //cerr << "up, down: " << up << ' ' << down << '\n';
        if (depth[par[down][i]] >= depth[up]) down = par[down][i];
    }
    return down;
}
int find_lca(int x, int y) {
    //cerr << "x, y: " << x << ' ' << y << '\n';
    if (x == y) return x;
    int lca = 0;
    for (int i = maxlog-1 ; i >= 0 ; --i) {
        if (par[x][i] == par[y][i]) lca = par[x][i];
        else {
            x = par[x][i];
            y = par[y][i];
        }
    }
    return lca;
}
int lca(int x, int y) {
    if (depth[x] == depth[y]) return find_lca(x, y);
    if (depth[x] < depth[y]) return find_lca(x, eq(y, x));
    return find_lca(eq(x, y), y);
}
void add(int x, int lca) {
    if (x == lca) return;
    ++vis[x];
    add(par[x][0], lca);
}
int x, y, ans;
int main () {
    ios_base :: sync_with_stdio(0);
    cin.tie(nullptr);
    cout.tie(nullptr);
    cin >> n >> k;
    for (int i = 1 ; i < n ; ++i) {
        cin >> x >> y;
        v[x].push_back(y);
        v[y].push_back(x);
    }
    init_par(1);
    for (int i = 1 ; i < maxlog ; ++i)
        for (int j = 1 ; j <= n ; ++j)
            par[j][i] = par[par[j][i-1]][i-1];
    for (int i = 0 ; i < k ; ++i) {
        cin >> x >> y;
        int lca1 = lca(x, y);
        add(x, lca1);
        add(y, lca1);
        ++vis[lca1];
    }
    for (int i = 1 ; i <= n ; ++i) {
        ans = max(ans, vis[i]);
    }
    cout << ans << '\n';
    return 0;
}
