// HLD
#include <iostream>
#include <vector>
using namespace std;

const int MAXN = 100200;

int n, k;
int u, v;
int ans;

vector<int> sys[MAXN];
int par[MAXN];
int val[MAXN];

vector<int> dp, ind;
int fa[MAXN];
void dfs(int curr, int depth)
{
    fa[curr] = dp.size();
    dp.push_back(depth);
    ind.push_back(curr);
    for(int i = 0; i < sys[curr].size(); i++){
        int nx = sys[curr][i];
        if(par[nx] == 0){
            par[nx] = curr;
            dfs(nx, depth+1);
            dp.push_back(depth);
            ind.push_back(curr);
        }
    }
}

int lcaTable[20][MAXN];

void tablegen()
{
    for(int i = 0; i < dp.size(); i++) lcaTable[0][i] = i;
    int pow2 = 1;
    for(int l = 1; pow2 < dp.size(); l++){
        for(int i = 0; i + pow2 < dp.size(); i++){
            if(dp[lcaTable[l-1][i]] <= dp[lcaTable[l-1][i+pow2]]){
                lcaTable[l][i] = lcaTable[l-1][i];
            }else{
                lcaTable[l][i] = lcaTable[l-1][i+pow2];
            }
        }
        pow2 *= 2;
    }
}

int lca(int a, int b)
{
    a = fa[a];
    b = fa[b];
    if(a > b) swap(a, b);
    int pow2 = 1;
    int st = 0;
    while(pow2 <= b-a){
        pow2 *= 2;
        st++;
    }
    pow2 /= 2;
    st--;
    if(dp[lcaTable[st][a]] <= dp[lcaTable[st][b-pow2+1]]){
        return ind[lcaTable[st][a]];
    }else{
        return ind[lcaTable[st][b-pow2+1]];
    }
}

void goUpAndUpdate(int curr, int to)
{
    val[curr]++;
    if(curr == to) return;
    goUpAndUpdate(par[curr], to);
}

int main(){

    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);

    cin >> n >> k;
    for(int i = 0; i < n-1; i++){
        cin >> u >> v;
        sys[u].push_back(v);
        sys[v].push_back(u);
    }
    par[1] = -1;
    dfs(1, 1);
    tablegen();
    for(int i = 0; i < k; i++){
        cin >> u >> v;
        //cout << lca(u, v) << endl;
        int h = lca(u, v);
        val[h]--;
        goUpAndUpdate(u, h);
        goUpAndUpdate(v, h);
    }

    for(int i = 0; i < n; i++){
        ans = max(ans, val[i]);
    }
    cout << ans << endl;

return 0;
}

