#include <iostream>
#include <cmath>
using namespace std;

const double LIMIT = 1000000;
struct fraction{
    int p;
    int q;
};

fraction transformV(double d){
    fraction output;
    int p, q = 1;
    while (d / (int)d != 1){
        d *= 10;
        q *= 10;
    }
    p = (int)d;
    while (p % 2 == 0 && q % 2 == 0){
        p /= 2;
        q /= 2;
    }
    while (p % 5 == 0 && q % 5 == 0){
        p /= 5;
        q /= 5;
    }
    output.p = p;
    output.q = q;

    return output;
}

int main(){
    int N;
    cin >> N;

    double a[N], b[N];
    cin >> a[0] >> b[0];
    double minSegmentV = b[0] - a[0];
    double maxV = minSegmentV;
    double currV, depth, minA, maxB;
    double ans;

    for (int i = 1; i < N; i++){
        cin >> a[i] >> b[i];
        currV = b[i] - a[i];
        depth = 0;
        minA = LIMIT;
        maxB = 0;
        minSegmentV = min(minSegmentV, currV);
        for (int j = i - 1; j >= 0; j--){
            if (b[i] < b[j] && b[i] > a[j]){
                depth++;
                minA = min(minA, a[i]);
                maxB = max(maxB, b[j]);
            } else if (b[j] < b[i] && b[j] > a[i]){
                depth++;
                minA = min(minA, a[j]);
                maxB = max(maxB, b[i]);
            }
        }
        if (depth > 0){
            if (depth > 1){
                break;
            }
            maxV = min(maxV, (maxB - minA)/(depth + 1));
        }
    }
    ans = min(minSegmentV, maxV);

    if (ans / (int)ans != 1){
        fraction ansF = transformV(ans);
        cout << ansF.p << "/" << ansF.q << endl;
    } else {
        cout << ans << endl;
    }

    return 0;
}
