#include<iostream>
#include<vector>
#include<algorithm>
#include<utility>
using namespace std;

const int maxN = 50000;
pair<int, int> scores[maxN];

void DFS(vector<int> graph[], int index, vector<int> path, int to, bool isVisited[])
{
    if(isVisited[index])
        return;

    isVisited[index] = true;
    path.push_back(index);

    if(index == to)
    {
        for(int i = 0; i < path.size(); i++)
        {
            scores[path[i]].first += 1;
            scores[path[i]].second = path[i] + 1;
        }
        return;
    }


    for(int i = 0; i < graph[index].size(); i++)
    {
        int newIndex = graph[index][i];
        if(!isVisited[newIndex])
            DFS(graph, newIndex, path, to, isVisited);
    }
}

int main()
{
    int N, K;
    cin >> N >> K;

    vector<int> graph[N];

    for(int i = 0; i < N - 1; i++)
    {
        int from;
        int to;
        cin >> from >> to;

        from -= 1;
        to -= 1;

        graph[from].push_back(to);
        graph[to].push_back(from);
    }

    for(int i = 0; i < K; i++)
    {
        bool isVisited[N] = {false};
        int from;
        int to;
        cin >> from >> to;

        from -= 1;
        to -= 1;

        vector<int> path;

        DFS(graph, from, path, to, isVisited);
    }

    sort(scores, scores + N);

    cout << scores[N - 1].second;

    return 0;
}
