#include <bits/stdc++.h>
#define endl '\n'

using namespace std;

const int maxn = 1e5 + 3;

int n;
pair <double, double> a[maxn];
void read()
{
    cin >> n;
    for (int i = 1; i <= n; i++)
        cin >> a[i].first >> a[i].second;
}

const double eps = 1e-4;

bool can(double x)
{
    double r = a[1].first + x;
    for (int i = 2; i <= n; i++)
    {
        if (a[i].first >= r || fabs(r - a[i].first) < eps)
            r = a[i].first + x;

        else
        {
            if (a[i].second < x + r)
                return false;

            r += x;
        }
    }

    return true;
}


void solve()
{
    sort (a + 1, a + n + 1);

    double low = 0, high = 1/.0;
    for (int i = 1; i <= n; i++)
        high = min(high, a[i].second - a[i].first);

    for (int i = 1; i <= 60; i++)
    {
        double mid = (low + high) / 2;
        if (can(mid))
            low = mid;

        else
            high = mid;
    }

    double ans = low;
    int p, q;
    for (int i = 1; i <= 1000000; i++)
    {
        if (i < ans)
        {
            if (fabs(ans - i) < eps)
            {
                cout << i << "/" << 1 << endl;
                return;
            }
        }

        else
        {
            int low = 1, high = 1000000;
            while (low < high)
            {
                int mid = (low + high + 1) / 2;
                double curr = (double)i / (double)mid;

                if (curr >= ans)
                    low = mid;

                else
                    high = mid - 1;
            }

            for (int j = -5; j <= 5; j++)
            {
                if (low + j < 1)
                continue;

                double curr = (double)i / (double)(low + j);
                if (fabs(curr - ans) < eps)
                {
                    cout << i << "/" << low + j << endl;
                    return;
                }
            }
        }
    }
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);

    read();
    solve();
}

/*
3
2 6
1 4
8 12
*/
