#include <bits/stdc++.h>
#define endl '\n'

using namespace std;

const int maxn = 1e5 + 3;

int n;
pair <double, double> a[maxn];
void read()
{
    cin >> n;
    for (int i = 1; i <= n; i++)
        cin >> a[i].first >> a[i].second;
}

bool can(double x)
{
    double r = a[1].first + x;
    for (int i = 2; i <= n; i++)
    {
        if (a[i].first >= r)
            r = a[i].first + x;

        else
        {
            double excess = a[i].second - a[i].first - x - (r - a[i].first);
            if (excess < 0)
                return false;

            r = max(r, a[i].second - excess);
        }
    }

    return true;
}

const double eps = 1e-6;

void solve()
{
    sort (a + 1, a + n + 1);

    double low = 0, high = INT_MAX;
    for (int i = 1; i <= n; i++)
        high = min(high, a[i].second - a[i].first);

    for (int i = 1; i <= 60; i++)
    {
        double mid = (low + high) / 2;
        if (can(mid))
            low = mid;

        else
            high = mid;
    }

    for (int i = 1; i <= 1000000; i++)
    {
        double res = low * (double)i;
        if (res - floor(res) < eps)
        {
            long long curr = floor(res);
            cout << curr << "/" << i << endl;
            return;
        }
    }
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);

    read();
    solve();
}

/*
3
2 6
1 4
8 12
*/
