#include <bits/stdc++.h>
#define endl '\n'

using namespace std;

const int maxn = 1e5 + 3;

int n, q;
vector <int> adj[maxn];
void read()
{
    cin >> n >> q;
    for (int i = 1; i <= n-1; i++)
    {
        int a, b;
        cin >> a >> b;

        adj[a].push_back(b);
        adj[b].push_back(a);
    }
}

int in[maxn], out[maxn];
bool is_upper(int a, int b)
{
    return in[a] <= in[b] && out[a] >= out[b];
}

int par[maxn][19];
int dfs_time;
int sub1[maxn], sub2[maxn], add[maxn];
void pre_dfs(int ver)
{
    in[ver] = ++dfs_time;
    for (auto i: adj[ver])
    if (i != par[ver][0])
    {
        par[i][0] = ver;
        pre_dfs(i);
    }

    out[ver] = ++dfs_time;
}

void precompute()
{
    for (int j = 1; j <= 18; j++)
        for (int i = 1; i <= n; i++)
        par[i][j] = par[par[i][j-1]][j-1];
}

int lca(int a, int b)
{
    if (is_upper(a, b))
        return a;

    if (is_upper(b, a))
        return b;

    for (int i = 18; i >= 0; i--)
        if (par[a][i] && !is_upper(par[a][i], b))
        a = par[a][i];

    return par[a][0];
}

int val[maxn];
void dfs(int ver)
{
    val[ver] = 0;
    for (auto i: adj[ver])
    if (i != par[ver][0])
    {
        dfs(i);
        val[ver] += val[i] - sub1[i];
    }

    val[ver] += add[ver];
    val[ver] -= sub2[ver];
}

void solve()
{
    pre_dfs(1);
    precompute();

    while (q--)
    {
        int a, b;
        cin >> a >> b;

        int c = lca(a, b);
        if (c == a)
        {
            add[b]++;
            sub1[a]++;
        }

        else
        if (c == b)
        {
            add[a]++;
            sub1[b]++;
        }

        else
        {
            add[a]++;
            add[b]++;
            sub1[c]++;
            sub2[c]++;
        }
    }

    dfs(1);

    int ans = 0;
    for (int i = 1; i <= n; i++)
        ans = max(ans, val[i]);

    cout << ans << endl;
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);

    read();
    solve();
}

/*
5 3
1 2
1 3
3 4
3 5
1 4
4 5
3 1
*/
