
#include <bits/stdc++.h>
using namespace std;
typedef long long ll;

const ll MAX_N = 1e5 + 10;

pair<ll, ll> inter[MAX_N];
ll n;

bool cmp(pair<ll, ll> a, pair<ll, ll> b) {
    if(a.second == b.second) {
        return a.first < b.first;
    }
    return a.second < b.second;
}

const ll INF = 1e12;

bool eval(long double x) {
    long double last = -INF;
    for(ll i = 0; i < n; i ++) {
        long double toGet = max(last, (long double)inter[i].first) + x;
        if(toGet > (long double)inter[i].second) {
            return false;
        }
        last = toGet;
    }
    return true;
}

pair<ll, ll> operator +(const pair<ll, ll> &a, const pair<ll, ll> &b) {
    return {a.first + b.first, a.second + b.second};
}

bool cmp2(const pair<ll, ll> &a, const pair<ll, ll> &b) {
    return a.first * b.second < b.first * a.second;
}

pair<ll, ll> getClosest(long double x) {
    long double mn = INF;
    pair<ll, ll> ret = {1, 0};
    for(ll q = 1; q <= 100000; q ++) {
        ll l = 0, r = INF;
        while(l < r - 1) {
            ll m = (l + r) / 2ll;
            if((long double)m <= (long double)x * (long double)q || (m - x * q) <= 1e-5) {
                l = m;
            } else {
                r = m;
            }
        }
        if(abs((long double)l / (long double)q - x) < mn) {
            mn = abs((long double)l / (long double)q - x);
            ret = {l, q};
        }
    }
    return ret;
}

signed main() {
    ios_base::sync_with_stdio(false); cin.tie(NULL);
    cin >> n;
    for(ll i = 0; i < n; i ++) {
        cin >> inter[i].first >> inter[i].second;
    }
    sort(inter, inter + n, cmp);
    long double l = 0, r = INF;
    for(int iter = 0; iter < 200; iter ++) {
        long double m = (l + r) / (long double)2;
        if(eval(m)) {
            l = m;
        } else {
            r = m;
        }
    }
    auto ret = getClosest(l);
    cout << ret.first << "/" << ret.second << endl;
}

/*
5 3
1 2
1 3
3 4
3 5
1 4
4 5
3 1
*/
