
#include <bits/stdc++.h>
using namespace std;
typedef long long ll;

const ll MAX_N = 1e5 + 10;

pair<ll, ll> inter[MAX_N];
ll n;

bool cmp(pair<ll, ll> a, pair<ll, ll> b) {
    if(a.second == b.second) {
        return a.first < b.first;
    }
    return a.second < b.second;
}

const ll INF = 1e12;

bool eval(long double x) {
    long double last = -INF;
    for(ll i = 0; i < n; i ++) {
        long double toGet = max(last, (long double)inter[i].first) + x;
        if(toGet > (long double)inter[i].second) {
            return false;
        }
        last = toGet;
    }
    return true;
}

pair<ll, ll> operator +(const pair<ll, ll> &a, const pair<ll, ll> &b) {
    return {a.first + b.first, a.second + b.second};
}

pair<ll, ll> getClosest(long double x) {
    ll down = floor(x);
    x -= down;
    long double mn = INF;
    pair<ll, ll> ret;
    pair<ll, ll> lft = {0, 1}, rght = {1, 1};
    for(int iter = 0; iter < 100; iter ++) {
        pair<ll, ll> mid = lft + rght;
        long double val = (long double)mid.first / (long double)mid.second;
        if(abs(val - x) <= mn) {
            ret = mid;
            mn = abs(val - x);
        }
        if(val + down <= x) {
            lft = mid;
        } else {
            rght = mid;
        }
    }
    ret.first += ret.second * down;
    return ret;
}

signed main() {
    ios_base::sync_with_stdio(false); cin.tie(NULL);
    cin >> n;
    for(ll i = 0; i < n; i ++) {
        cin >> inter[i].first >> inter[i].second;
    }
    sort(inter, inter + n, cmp);
    long double l = 0, r = INF;
    for(int iter = 0; iter < 100; iter ++) {
        long double m = (l + r) / (long double)2;
        if(eval(m)) {
            l = m;
        } else {
            r = m;
        }
    }
    auto ret = getClosest(l);
    cout << ret.first << "/" << ret.second << endl;
}

/*
5 3
1 2
1 3
3 4
3 5
1 4
4 5
3 1
*/
