
#include <bits/stdc++.h>
using namespace std;
typedef long long ll;

const ll MAX_N = 1e5 + 10, LOG = 20;
ll par[LOG][MAX_N], d[MAX_N];
vector<ll> g[MAX_N];
int in[MAX_N], out[MAX_N];
int tme = 0;

void dfs(ll x, ll p) {
    d[x] = d[p] + 1;
    par[0][x] = p;
    for(ll i = 1; i < LOG; i ++) {
        par[i][x] = par[i - 1][par[i - 1][x]];
    }
    in[x] = out[x] = tme ++;
    for(auto it : g[x]) {
        if(it == p) {continue;}
        dfs(it, x);
        out[x] = out[it];
    }
}

ll lca(ll a, ll b) {
    if(in[a] <= in[b] && out[a] >= in[b]) {
        return a;
    }
    for(int i = LOG - 1; i >= 0; i --) {
        if(in[par[i][a]] > in[b] || out[par[i][a]] < in[b]) {
            a = par[i][a];
        }
    }
    return par[0][a];
}

ll cnt[MAX_N], l[MAX_N], fake[MAX_N], ans[MAX_N];

void dfsAns(ll x, ll p) {
    for(auto it : g[x]) {
        if(it == p) {continue;}
        dfsAns(it, x);
        fake[x] += fake[it];
    }
    fake[x] += cnt[x];
    ans[x] = fake[x] - l[x];
    fake[x] -= 2 * l[x];
}

signed main() {
    ios_base::sync_with_stdio(false); cin.tie(NULL);
    int n, k;
    cin >> n >> k;
    in[0] = -1; out[0] = MAX_N;
    for(ll i = 0; i < n - 1; i ++) {
        ll a, b;
        cin >> a >> b;
        g[a].push_back(b);
        g[b].push_back(a);
    }
    dfs(1, 0);
    for(ll i = 0; i < k; i ++) {
        ll a, b;
        cin >> a >> b;
        cnt[a] ++;
        cnt[b] ++;
        l[lca(a, b)] ++;
    }
    dfsAns(1, 0);
    ll mx = 0;
    for(ll i = 1; i <= n; i ++) {
        if(ans[i] >= mx) {
            mx = ans[i];
        }
    }
    cout << mx << endl;
}
