
#include <bits/stdc++.h>
using namespace std;
typedef long long ll;

const ll MAX_N = 1e5 + 10, LOG = 20;
ll par[MAX_N][LOG], d[MAX_N];
vector<ll> g[MAX_N];

void dfs(ll x, ll p) {
    d[x] = d[p] + 1;
    par[x][0] = p;
    for(ll i = 1; i < LOG; i ++) {
        par[x][i] = par[par[x][i - 1]][i - 1];
    }
    for(auto it : g[x]) {
        if(it == p) {continue;}
        dfs(it, x);
    }
}

ll lca(ll a, ll b) {
    if(d[a] < d[b]) {swap(a, b);}
    for(ll i = LOG - 1; i >= 0; i --) {
        if(d[par[a][i]] >= d[b]) {
            a = par[a][i];
        }
    }
    if(a == b) {return a;}
    for(ll i = LOG - 1; i >= 0; i --) {
        if(par[a][i] != par[b][i]) {
            a = par[a][i];
            b = par[b][i];
        }
    }
    return par[a][0];
}

ll cnt[MAX_N], l[MAX_N], fake[MAX_N], ans[MAX_N];

void dfsAns(ll x, ll p) {
    for(auto it : g[x]) {
        if(it == p) {continue;}
        dfsAns(it, x);
        fake[x] += fake[it];
    }
    fake[x] += cnt[x];
    ans[x] = fake[x] - l[x];
    fake[x] -= 2 * l[x];
}

signed main() {
    ios_base::sync_with_stdio(false); cin.tie(NULL);
    int n, k;
    cin >> n >> k;
    for(ll i = 0; i < n - 1; i ++) {
        ll a, b;
        cin >> a >> b;
        g[a].push_back(b);
        g[b].push_back(a);
    }
    dfs(1, 0);
    for(ll i = 0; i < k; i ++) {
        ll a, b;
        cin >> a >> b;
        cnt[a] ++;
        cnt[b] ++;
        l[lca(a, b)] ++;
    }
    dfsAns(1, 0);
    ll mx = 0;
    for(ll i = 1; i <= n; i ++) {
        if(ans[i] >= mx) {
            mx = ans[i];
        }
    }
    cout << mx << endl;
}

/*
5 3
1 2
1 3
3 4
3 5
1 4
4 5
3 1
*/
