#include <bits/stdc++.h>
using namespace std;

typedef long long ll;

template<const ll n, class T>
void karatsuba(T *a, T *b, T *ret) {
    for(int i = 0; i < 2 * n; i ++) {
        ret[i] = 0;
    }
    if(n <= 32) {
        for(ll i = 0; i < n; i ++) {
            for(ll j = 0; j < n; j ++) {
                ret[i + j] += a[i] * b[j];
            }
        }
        return;
    } else {
        const ll half = n / 2;
        T low[n], high[n];
        T atmp[half], btmp[half], tmp[n];
        for(ll i = 0; i < half; i ++) {
            atmp[i] = a[i] + a[i + half];
            btmp[i] = b[i] + b[i + half];
        }
        karatsuba<half, T>(a, b, low);
        karatsuba<half, T>(a + half, b + half, high);
        karatsuba<half, T>(atmp, btmp, tmp);
        for(ll i = 0; i < n; i ++) {
            ret[i] += low[i];
            ret[i + half] += tmp[i] - low[i] - high[i];
            ret[i + 2 * half] += high[i];
        }
    }
}

const ll MAX_N = 1 << 18;
ll a[MAX_N], b[2 * MAX_N], c[2 * MAX_N];

signed main() {

    int fake, sum;
    cin >> fake; sum += fake;
    for(int i = 0; i < fake; i ++) {
        int x;
        cin >> x;
        sum += x;
    }
    srand(sum % 100);

    for(ll i = 0; i < MAX_N; i ++) {
        a[i] = rand() % 10;
    }
    karatsuba<MAX_N>(a, a, b);
    for(ll i = 0; i < MAX_N; i ++) {
        for(ll j = 0; j < MAX_N; j ++) {
            c[i + j] += a[i] * a[j];
        }
    }
    for(ll i = 0; i < 2 * MAX_N; i ++) {
        if(c[i] != b[i]) {
            cout << "Bad" << endl;
            assert(false);
            return 0;
        }
    }
}
