#include <bits/stdc++.h>
using namespace std;

typedef long long ll;

const ll MAX_N = 2e5 + 10;
ll dpLIS[MAX_N], dpLDS[MAX_N];
ll arr[MAX_N], n;

struct SegTree {
    ll tree[4 * MAX_N];
    SegTree() {
        for(ll i = 0; i < 4 * MAX_N; i ++) {
            tree[i] = 0;
        }
    }
    void upd(ll curr, ll l, ll r, ll ind, ll val) {
        if(l == r && l == ind) {
            tree[curr] = max(tree[curr], val);
            return;
        } else if(r < ind || l > ind) {
            return;
        }
        ll m = (l + r) / 2ll;
        upd(curr * 2, l, m, ind, val);
        upd(curr * 2 + 1, m + 1, r, ind, val);
        tree[curr] = max(tree[curr * 2], tree[curr * 2 + 1]);
    }
    ll ans(ll curr, ll l, ll r, ll ql, ll qr) {
        if(ql <= l && r <= qr) {
            return tree[curr];
        } else if(ql > r || qr < l) {
            return 0;
        }
        ll m = (l + r) / 2ll;
        return max(ans(curr * 2, l, m, ql, qr), ans(curr * 2 + 1, m + 1, r, ql, qr));
    }
};

SegTree LIS, LDS;

void calc() {
    for(ll i = 0; i < n; i ++) {
        dpLIS[i] = LIS.ans(1, 0, MAX_N - 1, 0, arr[i]) + 1;
        LIS.upd(1, 0, MAX_N - 1, arr[i], dpLIS[i]);
    }
    for(ll i = 0; i < n; i ++) {
        dpLDS[i] = LDS.ans(1, 0, MAX_N - 1, arr[i], MAX_N - 1) + 1;
        LDS.upd(1, 0, MAX_N - 1, arr[i], dpLDS[i]);
    }
}

signed main() {
    ios_base::sync_with_stdio(false); cin.tie(NULL);
    cin >> n;
    for(ll i = 0; i < n; i ++) {
        cin >> arr[i];
    }
    calc();
    ll ret = 0;
    for(ll i = 0; i < n; i ++) {
        if(dpLIS[i] + dpLDS[i] - 1 >= ret) {
            ret = dpLIS[i] + dpLDS[i] - 1;
        }
    }
    cout << n - ret << endl;
}
