#include <bits/stdc++.h>
using namespace std;

const int MAX_N = 2e5 + 10;
int dpLIS[MAX_N], dpLDS[MAX_N];
int arr[MAX_N], n;

struct SegTree {
    int tree[4 * MAX_N];
    SegTree() {
        for(int i = 0; i < 4 * MAX_N; i ++) {
            tree[i] = 0;
        }
    }
    void upd(int curr, int l, int r, int ind, int val) {
        if(l == r && l == ind) {
            tree[curr] = max(tree[curr], val);
            return;
        } else if(r < ind || l > ind) {
            return;
        }
        int m = (l + r) / 2ll;
        upd(curr * 2, l, m, ind, val);
        upd(curr * 2 + 1, m + 1, r, ind, val);
        tree[curr] = max(tree[curr * 2], tree[curr * 2 + 1]);
    }
    int ans(int curr, int l, int r, int ql, int qr) {
        if(ql <= l && r <= qr) {
            return tree[curr];
        } else if(ql > r || qr < l) {
            return 0;
        }
        int m = (l + r) / 2ll;
        return max(ans(curr * 2, l, m, ql, qr), ans(curr * 2 + 1, m + 1, r, ql, qr));
    }
};

SegTree LIS, LDS;

void calc() {
    for(int i = 0; i < n; i ++) {
        dpLIS[i] = LIS.ans(1, 0, MAX_N - 1, 0, arr[i]) + 1;
        LIS.upd(1, 0, MAX_N - 1, arr[i], dpLIS[i]);
    }
    for(int i = 0; i < n; i ++) {
        dpLDS[i] = LDS.ans(1, 0, MAX_N - 1, arr[i], MAX_N - 1) + 1;
        LDS.upd(1, 0, MAX_N - 1, arr[i], dpLDS[i]);
    }
}

int main() {
    cin >> n;
    for(int i = 0; i < n; i ++) {
        cin >> arr[i];
    }
    calc();
    int ret = 0;
    for(int i = 0; i < n; i ++) {
        if(dpLIS[i] + dpLDS[i] - 1 >= ret) {
            ret = dpLIS[i] + dpLDS[i] - 1;
        }
    }
    cout << n - ret << endl;
}
