#include <bits/stdc++.h>
#define maxn 50004
#define maxk 100005
using namespace std;

int n, k, ans;
vector <int> adj [maxn];
int par [maxn], brup [maxn], brdown [maxn], brconn [maxn];
vector <pair <int, int> > euler;
int pos [maxn];
pair <int, int> sparse [2 * maxn][20];

void dfs1 (int a, int d){
    pos [a] = euler.size ();
    euler.push_back ({d, a});
    for (int i : adj [a]){
        if (i != par [a]){
            par [i] = a;
            dfs1 (i, d + 1);
            euler.push_back ({d, a});
        }
    }
}

void build (){
    int sz = euler.size ();
    for (int i = 0; i < sz; i ++) sparse [i][0] = euler [i];
    for (int i = 1; (1 << i) < sz; i ++){
        for (int j = 0; j + (1 << i - 1) < sz; j ++){
            sparse [j][i] = min (sparse [j][i - 1], sparse [j + (1 << i - 1)][i - 1]);
        }
    }
}

int lca (int u, int v){
    u = pos [u];
    v = pos [v];
    if (u > v) swap (u, v);
    int dist = v - u + 1, k = 31 - __builtin_clz (dist);
    auto rmq = min (sparse [u][k], sparse [v - (1 << k) + 1][k]);
    return rmq.second;
}

int dfs2 (int a){
    int x = brup [a] - brconn [a];
    for (int i : adj [a]){
        if (i != par [a]) x += dfs2 (i);
    }
    ans = max (ans, x);
    return x - brdown [a];
}

int main (){

    ios::sync_with_stdio (false);
    cin.tie (0);

	cin >> n >> k;
	for (int i = 1; i < n; i ++){
        int u, v;
        cin >> u >> v;
        adj [u].push_back (v);
        adj [v].push_back (u);
	}
	dfs1 (1, 0);
	build ();
	for (int i = 0; i < k; i ++){
        int u, v;
        cin >> u >> v;
        int w = lca (u, v);
        if (w == u) brup [v] ++, brdown [u] ++;
        else if (w == v) brup [u] ++, brdown [v] ++;
        else brup [u] ++, brup [v] ++, brdown [w] ++, brconn [w] ++;
	}
	dfs2 (1);
	cout << ans << '\n';

}
