#include <iostream>
#include <queue>
#include <utility>
#include <tuple>
#include <string.h>
using namespace std;
typedef long long lon;
#define endl '\n'
lon tests;
const lon INF = (1 << 30);
pair<lon, lon> dirs[] = {{2, -1}, {2, 1}, {1, 2}, {-1, 2}, {-2, 1}, {-2, -1}, {-1, -2}, {1, -2}};
pair<lon, lon> eval(string param)
{
    lon first = param[1] - '1', second = param[0] - 'a';
    return {first, second};
}
lon u[8][8], edno[8][8], dve[8][8];
struct temp{
    pair<lon, lon> cur; lon dir;
    temp(){}
};
temp setup(pair<lon, lon> a, lon b)
{
    temp res; res.cur = a; res.dir = b; return res;
}
void crack(temp t, pair<lon, lon>& a, lon& b)
{
    a = t.cur; b = t.dir;
}
bool exist(lon x, lon y)
{
    return x >= 0 && y >= 0 && x < 8 && y < 8;
}
queue<temp> q;
void bfs(pair<lon, lon> start, lon p)
{
    memset(u, 0, sizeof(u));
    q.push(setup(start, -1));
    u[start.first][start.second] = 1;
    if(p == 1) edno[start.first][start.second] = 0;
    else dve[start.first][start.second] = 0;
    while(!q.empty()){
        pair<lon, lon> pa; lon dir;
        crack(q.front(), pa, dir); q.pop();
        lon x, y; tie(x, y) = pa;
        if(dir != -1){
            lon bx = x - dirs[dir].first, by = y - dirs[dir].second;
            if(p == 1) edno[x][y] = edno[bx][by] + 1;
            else dve[x][y] = dve[bx][by] + 1;
        }
        u[x][y] = 1;
        for(lon i = 0; i < 8; ++i){
            lon nx = x + dirs[i].first, ny = y + dirs[i].second;
            if(!exist(nx, ny)) continue;
            if(u[nx][ny]) continue;
            u[nx][ny] = 1;
            //cout << "{" << nx << ' ' << ny << ' ' << i << "}" << endl;
            q.push(setup({nx, ny}, i));
        }
    }
}
int main()
{
    cin.tie(0); ios::sync_with_stdio(false);
    cin >> tests;
    for(lon i = 0; i < tests; ++i){
        string sone, stwo;
        cin >> sone >> stwo;
        memset(edno, -1, sizeof(edno)); memset(dve, -1, sizeof(dve));
        pair<lon, lon> one = eval(sone), two = eval(stwo);
        bfs(one, 1); bfs(two, 2);
        lon minimum = INF;
        for(lon i = 0; i < 8; ++i){
            for(lon z = 0; z < 8; ++z){
                if(edno[i][z] == -1 || dve[i][z] == -1 || edno[i][z] != dve[i][z]) continue;
                minimum = min(minimum, edno[i][z]);
            }
        }
        if(minimum == INF) cout << -1 << endl;
        else cout << minimum << endl;
    }
    return 0;
}
