#include <iostream>
#include <queue>
#include <utility>
#include <tuple>
#include <string.h>
using namespace std;
#define endl '\n'
int tests;
const int INF = (1 << 30);
pair<int, int> dirs[] = {{2, -1}, {2, 1}, {1, 2}, {-1, 2}, {-2, 1}, {-2, -1}, {-1, -2}, {1, -2}};
pair<int, int> eval(string param)
{
    int first = param[1] - '1', second = param[0] - 'a';
    return {first, second};
}
int u[8][8], edno[8][8], dve[8][8];
struct temp{
    pair<int, int> cur; int dir;
    temp(){}
};
temp setup(pair<int, int> a, int b)
{
    temp res; res.cur = a; res.dir = b; return res;
}
void crack(temp t, pair<int, int>& a, int& b)
{
    a = t.cur; b = t.dir;
}
bool exist(int x, int y)
{
    return x >= 0 && y >= 0 && x < 8 && y < 8;
}
queue<temp> q;
void bfs(pair<int, int> start, int p)
{
    memset(u, 0, sizeof(u));
    q.push(setup(start, -1));
    u[start.first][start.second] = 1;
    if(p == 1) edno[start.first][start.second] = 0;
    else dve[start.first][start.second] = 0;
    while(!q.empty()){
        pair<int, int> pa; int dir;
        crack(q.front(), pa, dir); q.pop();
        int x, y; tie(x, y) = pa;
        if(dir != -1){
            int bx = x - dirs[dir].first, by = y - dirs[dir].second;
            if(p == 1) edno[x][y] = edno[bx][by] + 1;
            else dve[x][y] = dve[bx][by] + 1;
        }
        u[x][y] = 1;
        for(int i = 0; i < 8; ++i){
            int nx = x + dirs[i].first, ny = y + dirs[i].second;
            if(!exist(nx, ny)) continue;
            if(u[nx][ny]) continue;
            u[nx][ny] = 1;
            //cout << "{" << nx << ' ' << ny << ' ' << i << "}" << endl;
            q.push(setup({nx, ny}, i));
        }
    }
}
int main()
{
    cin.tie(0); ios::sync_with_stdio(false);
    cin >> tests;
    for(int i = 0; i < tests; ++i){
        string sone, stwo;
        cin >> sone >> stwo;
        memset(edno, -1, sizeof(edno)); memset(dve, -1, sizeof(dve));
        pair<int, int> one = eval(sone), two = eval(stwo);
        bfs(one, 1); bfs(two, 2);
        int minimum = INF;
        for(int i = 0; i < 8; ++i){
            for(int z = 0; z < 8; ++z){
                if(edno[i][z] == -1 || dve[i][z] == -1 || edno[i][z] != dve[i][z]) continue;
                minimum = min(minimum, edno[i][z]);
            }
        }
        if(minimum == INF) cout << -1 << endl;
        else cout << minimum << endl;
    }
    return 0;
}
