#include<iostream>
#include<cstring>
#include<queue>
#include<utility>
using namespace std;
const int MAXN=8,INF=1e9;
pair<int,int> dirs[8]={{1,-2},{2,-1},{2,1},{1,2},{-1,2},{-2,1},{-2,-1},{-1,-2}};
int turns[2][MAXN][MAXN];
void calc_bfs(int startx, int starty, int ind){
    queue<pair<int,int>> bfs;
    bfs.push({startx,starty});
    turns[ind][startx][starty]=0;
    while(!bfs.empty()){
        pair<int,int> curr=bfs.front();
        bfs.pop();
        for(int i=0;i<8;++i){
            int nextx=curr.first+dirs[i].first;
            int nexty=curr.second+dirs[i].second;
            if(nextx>=0 and nextx<MAXN and nexty>=0 and nexty<MAXN){
                if(turns[ind][nextx][nexty]==-1){
                    turns[ind][nextx][nexty]=turns[ind][curr.first][curr.second]+1;
                    bfs.push({nextx,nexty});
                }
            }
        }
    }
}
int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int tests;
    cin>>tests;
    while(tests--){
        char c1,c2;
        int row1,col1,row2,col2;
        cin>>c1>>row1>>c2>>row2;
        --row1;
        --row2;
        col1=c1-'a';
        col2=c2-'a';
        memset(turns,-1,sizeof(turns));
        calc_bfs(row1,col1,0);
        calc_bfs(row2,col2,1);
        int res=INF;
        for(int i=0;i<MAXN;++i){
            for(int i2=0;i2<MAXN;++i2){
                if(turns[0][i][i2]==turns[1][i][i2] and turns[0][i][i2]<res){
                    res=turns[0][i][i2];
                }
            }
        }
        cout<<(res==INF ? -1 : res)<<endl;
    }
return 0;
}
/**
5
h1 g8
c4 b7
a2 b7
d3 c1
e4 f1
*/
