#include <stdio.h>
#include <stdlib.h>
#include <limits.h>

int graph[10000][10000] = {0};
int N, M, C, K;

int minDistance(int dist[], bool sptSet[]){
    int minn = INT_MAX, min_index;

    for(int n = 0; n < N; n++)
        if (sptSet[n] == 0 && dist[n] <= minn){
            minn = dist[n];
            min_index = n;
        }
    return min_index;
}

int printSolution(int dist[]){
    int c = 0;
    int arr[10000] = {0};
    for(int i = 0; i < N; i++){
        if(dist[i] > K){
            arr[c] = i+1;
            c++;
        }
    }
    printf("%d\n", c);
    for(int i = 0; i < c; i++){
        printf("%d\n", arr[i]);
    }
}

void dijkstra(int graph[10000][10000], int C)
{
    int dist[10000];
    bool sptSet[10000];
    for (int i = 0; i < N; i++){
        dist[i] = INT_MAX, sptSet[i] = 0;
    }
    dist[C] = 0;
    for (int i = 0; i < N - 1; i++){
        int u = minDistance(dist, sptSet);
        sptSet[u] = 1;
        for(int n = 0; n < N; n++){
            if (!sptSet[n] && graph[u][n] && dist[u] != INT_MAX && dist[u] + graph[u][n] < dist[n]){
                dist[n] = dist[u] + graph[u][n];
            }
        }
    }
    printSolution(dist);
}

int main(){
    int u, v;
    scanf("%d%d%d%d", &N, &M, &C, &K);

    for(int i = 0; i < M; i++){
        scanf("%d%d", &u, &v);
        graph[u-1][v-1] = 1;
        graph[v-1][u-1] = 1;
    }

    dijkstra(graph, C-1);

    return 0;
}
