#include <iostream>
#include <vector>
#include <algorithm>
#include <queue>

using namespace std;

const int maxn = 100005;
vector<int> adj[maxn];
bool used[maxn];

int distFromBeg[maxn];

queue<int> frontier;

vector<int> answer;

int main(){

    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    int n, m, beginVert, dist;
    cin >> n >> m >> beginVert >> dist;

    for(int i=0; i<m; i++){
        int u, v;
        cin >> u >> v;
        adj[u].push_back(v);
        adj[v].push_back(u);
    }

    distFromBeg[beginVert] = 0;
    frontier.push(beginVert);
    used[beginVert] = true;

    while(!frontier.empty()){
        int curr = frontier.front();
        frontier.pop();

        if(distFromBeg[curr] > dist) answer.push_back(curr);

        for(int i=0; i<adj[curr].size(); i++){
            int neighbour = adj[curr][i];

            if(used[neighbour]) continue;
            used[neighbour] = true;

            distFromBeg[neighbour] = distFromBeg[curr] + 1;
            frontier.push(neighbour);
        }
    }

    sort(answer.begin(), answer.end());

    cout << answer.size() << endl;

    for(int i=0; i<answer.size(); i++){
        cout << answer[i] << endl;
    }

    return 0;
}
