#include <iostream>
#include <vector>
#include <queue>
#include <cstring>

const int MAXN = 1e5 + 10;

std::vector<int> adj[MAXN], ans;
std::queue<int> q;
int dost[MAXN];

int main()
{
    std::cin.tie(NULL);
    std::cout.tie(NULL);
    std::ios_base::sync_with_stdio(false);
    memset(dost, -1, sizeof(dost));

    int n, m, c, k;
    std::cin >> n >> m >> c >> k;

    for(int i = 0; i < m; ++ i)
    {
        int u, v;
        std::cin >> u >> v;
        adj[u].push_back(v);
        adj[v].push_back(u);
    }

    q.push(c);
    dost[c] = 0;

    while(!q.empty())
    {
        int curr = q.front();
        q.pop();

        for(int i = 0; i < adj[curr].size(); ++ i)
        {
            int next = adj[curr][i];
            if(dost[next] == -1)
            {
                dost[next] = dost[curr] + 1;
                q.push(next);
            }
        }
    }

    for(int i = 1; i <= n; ++ i)
    {
        //std::cout << dost[i] << '\n';
        if(dost[i] > k)
        {
            ans.push_back(i);
        }
    }

    std::cout << ans.size() << '\n';
    for(int i = 0; i < ans.size(); ++ i)
    {
        std::cout << ans[i] << '\n';
    }

    return 0;
}
