#include <iostream>
#include <vector>
#include <queue>
#include <set>

struct Node{
std::vector<long long> next_nodes;
};

void bfs(Node* graph, bool* isvisited, long long* distance, std::set<long long> & solutions, long long nodes, long long start, long long periphery){

    std::queue<long long> BFS;
    isvisited[start] = true;
    distance[start] = 0;
    BFS.push(start);

    while(!BFS.empty()){
        long long m = BFS.front();
        BFS.pop();
        for(long long i = 0; i < graph[m].next_nodes.size(); ++i){
            if(!isvisited[graph[m].next_nodes[i]]){

                BFS.push(graph[m].next_nodes[i]);
                isvisited[graph[m].next_nodes[i]] = true;
                distance[graph[m].next_nodes[i]] = distance[m] + 1;

                if(distance[graph[m].next_nodes[i]] > periphery){
                    solutions.insert(graph[m].next_nodes[i]);
                }
            }
        }
    }


}

int main()
{
    long long nodes, links, start, periphery;
    std::cin >> nodes;
    Node* graph = new Node[nodes + 1];
    bool* isvisited = new bool[nodes + 1];
    for(long long i = 0; i <= nodes; ++i){
        isvisited[i] = false;
    }
    long long* distance = new long long[nodes + 1];
    for(long long i = 0; i <= nodes; ++i){
        distance[i] = -1;
    }
    std::cin >> links;
    std::cin >> start;
    std::cin >> periphery;

for(long long i = 0; i < links; i++){
    long long a, b;
    std::cin >> a >> b;
    graph[a].next_nodes.push_back(b);
    graph[b].next_nodes.push_back(a);
}
//do tuk raboti

std::set<long long> solutions;
bfs(graph, isvisited, distance, solutions, nodes, start, periphery);
std::cout << solutions.size() << '\n';
for(std::set<long long>::iterator i = solutions.begin(); i != solutions.end(); i++){
    std::cout << (*i) << '\n';
}

    return 0;
}
