#include <iostream>
#include <vector>
#include <queue>

using namespace std;

const int MAX_N = 100000;
const int MAX_M = 100000;

vector<int> neigh [MAX_N] ;

int n, m, c,k;

int dist[MAX_N];
int visited[MAX_N];

int bfs(int v, int depth) {
    queue<int> q;
    q.push(v);
    visited[v] = true;
    while(!q.empty()) {
        int curr = q.front();
        cout << curr << endl;
        for(int i = 0; i < neigh[curr].size(); ++ i) {
            if(visited[neigh[curr][i]]) continue;
            int _dist = dist[curr] + 1;
            //cout << _dist << " " << dist[neigh[curr][i]] << endl;
            if(_dist > depth) continue;
            cout << "visiting " << neigh[curr][i] << endl;
            dist[neigh[curr][i]] = _dist;
            visited[neigh[curr][i]] = true;
            q.push(neigh[curr][i]);
        }
        q.pop();
    }
}


int main() {
    cin >> n >> m >> c >> k;
    for(int i = 0;i < m; i ++) {
        int u, v;
        cin >> u >> v;
        u--;
        v--;
        neigh[u].push_back(v);
        neigh[v].push_back(u);
    }
    bfs(c-1,k);
    int count = 0;
    for(int i = 0; i < n; i ++ ) {
        if(!visited[i]) count ++;
        cout << dist[i] << " ";
    }
    cout << count << endl;
    for(int i = 0; i < n; i ++ ) {
        if(!visited[i]) cout << i + 1 << endl;
    }
}
