#include <iostream>
#include <set>
 
struct Point {
	short x, y;
	/*
	bool operator==(const Point& other) const{
		return this->x == other.x && this->y == other.y;
	}*/
	
	bool operator<(const Point& other) const{
		return this->x != other.x && this->y != other.y);
	}
};

std::set<Point> lines;
class Line {
	Point a, b;
	double m, c;

	bool is_int(double value) {
		return value == int(value);
	}

	void add_by_x() {
		for (short i = a.x; i <= b.x; ++i) {
			double y = m * i + c;
			if (is_int(y))
				lines.insert({i, short(y)});
		}
	}

	void add_by_y() {
		Point beg = (a.y < b.y ? a : b);
		Point end = (a.y > b.y ? a : b);

		for (short i = beg.y; i <= end.y; ++i){
			lines.insert({a.x, i});
		}
	}
public:
	Line(Point a, Point b) {
		this->a = a.x < b.x ? a : b;
		this->b = a.x < b.x ? b : a;
	}

	void add_points() {
		if (a.x == b.x) {
			add_by_y();
			return;
		} 
				
		m = double(b.y - a.y) / (b.x - a.x);
		c = double(a.y) - m * a.x;
		
		add_by_x();
	}
};

int main()
{  
	
    short n, x1, x2, y1, y2;
    std::cin >> n;
    
    for (short i = 0; i < n; ++i) {
    	std::cin >> x1 >> y1 >> x2 >> y2;
    	Line({x1, y1}, {x2, y2}).add_points();
    }
 /*   
    for (auto i = lines.begin(); i != lines.end(); ++i) {
    	std::cout << i->x << i->y << std::endl;
    }
   */ 
	std::cout << lines.size();

	return 0;
}
