#include <iostream>
#include <set>
#include <math.h>

// maybe fast pow if it's slow

using namespace std;



int countDivisors(int n) 
{ 
    int cnt = 0; 
    int root = sqrt(n);
    for (int i = 1; i <= root; i++) { 
        if (n % i == 0) { 
            if (n / i == i){
            	cnt++;
            } else{
            	cnt+=2;
            }
        } 
    } 
    return cnt - 1; 
} 

unsigned long long solve_fast(int n){
	int primes[n + 1];
	for (int i = 0; i <= n; ++i)
	{
		primes[i] = -1;
	}
	primes[1] = 1;
	for (int i = 2; i <= n; ++i)
	{
		if(primes[i] == -1){
			primes[i] = 1;
			int p = 2;
			while(1){
				int cur = pow(i, p);
				if(cur > n){
					break;
				}
				primes[cur] = 0;
				p++;
			}
		}
	}

	for (int i = 1; i <= n; ++i)
	{
		//cout << i << ": " << primes[i] << endl;
	}

	int table[n + 1];
	for (int i = 0; i < n + 1; ++i)
	{
		table[i] = 0;
	}


	for (int i = 1; i <= n; ++i)
	{

		table[i] = countDivisors(i);
	}

	for (int i = 1; i <= n; ++i)
	{
		//cout << i << ": " << table[i] << endl;
	}

	unsigned long long result = 0;

	for (int i = 1; i <= n; ++i)
	{
		int possible = n - i + 1;

		int divs = table[i];

		//result += possible;
		//result -= divs;
		if(divs == 1){
			result += i - 1;
		}else{
			result += i - divs;
		}
		// if i is prime:
			//add i - 1;
		// else add i - table[i] - 1
		
	}



	return result;
}

unsigned long long solve_slow(int n){
	set<double> mem;

	for (int ch = 1; ch <= n; ++ch)
	{
		for (int zn = ch; zn <= n; ++zn)
		{
			//cout << ch << '/' << zn << ':' << ch/zn << endl;
			mem.insert((double)ch/zn);
		}
	}

	return mem.size();
}

int main()
{
	int n;
	cin >> n;

	for (int i = 1; i <= 25; ++i)
	{

		//cout << "i: " << i << " divs: " << countDivisors(i) << endl;
	}


	for (int i = 1; i < 25; ++i)
	{
		//cout << "n: " << i << " expected: " << solve_slow(i) << " actual: " << solve_fast(i) << endl;
	}
	
	cout << solve_slow(n) << endl;	
}
