#include <iostream>
#include <set>
#include <math.h>

// maybe fast pow if it's slow

using namespace std;

int countDivisors(int n) 
{ 
    int cnt = 0; 
    int root = sqrt(n);
    for (int i = 1; i <= root; i++) { 
        if (n % i == 0) { 
            if (n / i == i){
            	cnt++;
            } else{
            	cnt+=2;
            }
        } 
    } 
    return cnt; 
} 

unsigned long long solve_fast(int n){


	int table[n + 1];
	for (int i = 0; i < n + 1; ++i)
	{
		table[i] = 0;
	}


	for (int i = 1; i <= n; ++i)
	{

		table[i] = countDivisors(i);
	}

	unsigned long long result = 0;

	for (int i = 1; i <= n; ++i)
	{
		result += i - table[i] + 1;
	}

	return result;
}

unsigned long long solve_slow(int n){
	set<double> mem;

	for (int ch = 1; ch <= n; ++ch)
	{
		for (int zn = ch; zn <= n; ++zn)
		{
			//cout << ch << '/' << zn << ':' << ch/zn << endl;
			mem.insert((double)ch/zn);
		}
	}

	return mem.size();
}

int main()
{
	int n;
	cin >> n;


	for (int i = 1; i < 30; ++i)
	{
		//cout << "n: " << i << " expected: " << solve_slow(i) << " actual: " << solve_fast(i) << endl;
	}
	
	cout << solve_fast(n) << endl;	
}
