#include <stdio.h>
#include <stdlib.h>

int calculate_intersected_points(int x1, int x2, int y1, int y2) {
	return y2 - y1 + 1; // +1 to include the end vertex
}

void save_distinct_point(int* stored_points, int n, int x) {
	stored_points[n] = x;
}

int get_intersected_points(int x1, int x2, int y1, int y2, int x3, int x4, int y3, int y4) { // takes 2 points
	return (y1 == y3 && y2 != y4) || (y2 == y4 && y1 != y3) ? 1 : 0;
}

int main() {
	int n; // n lines
	scanf("%d", &n);

	int x1, x2, y1, y2, points_sum = 0, intersected_points_sum = 0;
	int prev_x1, prev_x2, prev_y1, prev_y2;

	for(int i = 0; i < n; i++) {
		scanf("%d %d %d %d", &x1, &y1, &x2, &y2);
		points_sum += calculate_intersected_points(x1, x2, y1, y2);
		if(i != 0) intersected_points_sum += get_intersected_points(x1, x2, y1, y2, prev_x1, prev_x2, prev_y1, prev_y2);
		prev_x1 = x1;
		prev_x2 = x2;
		prev_y1 = y1;
		prev_y2 = y2;
	}

	printf("%d", points_sum - intersected_points_sum);
	// points = length + 1
	// y axis
	// points calculated need to be able to lie on the lines
	// if not on same y => pythagor
	// if x is between two y => intersection
}
