#include <stdio.h>
#include <stdlib.h>
#include <math.h>

struct point_t {
	int x1;
	int y1;
	int x2;
	int y2;
};

int calculate_intersected_points(struct point_t point) {
	return point.y2 - point.y1 + 1; // +1 to include the end vertex
}

int is_point_stored(int n, struct point_t stored_points[n], struct point_t point) {
	for(int i = 0; i < n; i++) {
		if((stored_points[i].x1 == point.x1 && stored_points[i].y1 == point.y1) && 
			(stored_points[i].x2 == point.x2 && stored_points[i].y2 == point.y2)) return 1;
	}
	return 0;
}

int get_intersected_points(struct point_t point) { // takes 2 points and finds whether they intersect
	return  ? 1 : 0;
}

int is_limit(int coord) {
	return coord < -500 || coord > 500;
}

int main() {

	int n; // n lines
	scanf("%d", &n);
	if(n < 0 || n > 5000) return 0;

	struct point_t point;
	int points_sum = 0, intersect_x, intersect_y;

	for(int i = 0; i < n; i++) {
		scanf("%d %d %d %d", &point.x1, &point.y1, &point.x2, &point.y2);
		if(is_limit(point.x1) || is_limit(point.y1) || is_limit(point.x2) || is_limit(point.y2)) return 0;
		intersect_x = intersect_y = get_intersected_points(point);
		points_sum += 1;
	}

	printf("%d", points_sum);

	// points = length + 1
	// y axis
	// points calculated need to be able to lie on the lines
	// if not on same y => pythagor
	// if x is between two y => intersection
	// intersection at a 45 degree and 90 degree angle
}
