#include <stdio.h>
#include <stdlib.h>
#include <math.h>

struct point_t {
	int x1;
	int y1;
	int x2;
	int y2;
};

int calculate_intersected_points(struct point_t point) {
	return point.y2 - point.y1 + 1; // +1 to include the end vertex
}

int is_point_stored(int n, struct point_t stored_points[n], struct point_t point) {
	for(int i = 0; i < n; i++) {
		if((stored_points[i].x1 == point.x1 && stored_points[i].y1 == point.y1) && 
			(stored_points[i].x2 == point.x2 && stored_points[i].y2 == point.y2)) return 1;
	}
	return 0;
}

int get_intersected_points(struct point_t point1, struct point_t point2) { // takes 2 points and finds whether they intersect
	// return (y1 == y3 && y2 != y4) || (y2 == y4 && y1 != y3) ? 1 : 0;
	return abs(point1.x1 -point2.x2) % 2 != 0 ? 1 : 0;
}

int main() {

	int n; // n lines
	scanf("%d", &n);

	struct point_t point, prev_point;
	int points_sum = 0, intersected_points_sum = 0;

	for(int i = 0; i < n; i++) {
		scanf("%d %d %d %d", &point.x1, &point.y1, &point.x2, &point.y2);
		points_sum += calculate_intersected_points(point);
		if(i != 0) intersected_points_sum += get_intersected_points(point, prev_point);
		prev_point.x1 = point.x1;
		prev_point.x2 = point.x2;
		prev_point.y1 = point.y1;
		prev_point.y2 = point.y2;
	}

	printf("%d", points_sum - intersected_points_sum);

	// points = length + 1
	// y axis
	// points calculated need to be able to lie on the lines
	// if not on same y => pythagor
	// if x is between two y => intersection
}
