#include <iostream>
#include <algorithm>
#include <string>
#include <map>
#include <vector>
using namespace std;

/*
1 - 1
2 - 2
3 - 4
4 - 6
5 - 10
6 - 12
7 - 18
8 - 22
*/

int gcd(int a, int b) {
	if (abs(b) > abs(a)) {
		return gcd(b, a);
	}
	if (b == 0) {
		return abs(a);
	}
	return gcd(b, a%b);
}

int* primes_to(int n) {
	int* primes = new int[n];
	for (int i=0; i<n; ++i) {
		primes[i] = 1;
	}
	primes[0] = 0;
	for (int i=2; i<=n; ++i) {
		if (primes[i-1]) {
			for (int j=i<<1; j<=n; j+=i) {
				primes[j-1] = 0;
			}
		}
	}
	return primes;
}

int main() {
	int d;
	cin >> d;
	int* primes = primes_to(d);
	int sum = 1;

	for (int i=1; i<=d; ++i) {
		if (primes[i-1]) {
			sum += i-1;
			continue;
		}
		if (i % 2) {
			for (int j=1; j<=(i-1)>>1; ++j) {
				if (gcd(i,j)==1) {
					sum += 2;
				}
			}
		} else {
			for (int j=1; j<=i>>1; ++j) {
				if (gcd(i,j)==1) {
					sum += 2;
				}
			}
		}
	}

	cout << sum << endl;
}
