#include <iostream>
#include <vector>
#include <cmath>
using std::cin; using std::cout; using std::endl;

struct line { 
	int x1, y1, x2, y2;
	double dx, dy, len;
};
std::vector<line> lines;

bool query(int x, int y) {
	for(auto l : lines) {
		double pdx = (l.x2-x);
		double pdy = (l.y2-y);
		double lp = std::sqrt(pdx*pdx + pdy*pdy);

		if(lp == 0) return 1;

		if( (l.dx / l.len == pdx / lp) 
		and (l.dy / l.len == pdy / lp)
		and lp <= l.len) {
			return 1;
		}
	}
	return 0;
}

int main() {
	std::cin.tie(nullptr);
	std::ios_base::sync_with_stdio(false);

	int n;
	cin >> n;
	lines.resize(n);
	for(int i = 0;i < n;i ++) {
		cin >> lines[i].x1 >> lines[i].y1 >> lines[i].x2 >> lines[i].y2;
		if(lines[i].x1 > lines[i].x2) {
			std::swap(lines[i].x1, lines[i].x2);
			std::swap(lines[i].y1, lines[i].y2);
		}
		lines[i].dx = (lines[i].x2-lines[i].x1);
		lines[i].dy = (lines[i].y2-lines[i].y1);
		lines[i].len = std::sqrt(lines[i].dx*lines[i].dx + lines[i].dy*lines[i].dy);

	}
	int ans = 0;
	for(int x = -500;x <= 500;x ++) {
		for(int y = -500;y <= 500;y ++) {
			ans += query(x, y);
		}
	}
	cout << ans << endl;
}
