#include <iostream>
#include <vector>
#include <algorithm>
using std::cin; using std::cout; using std::endl;

const int MAX_N = 100100;
int conn[MAX_N], dead[MAX_N];
std::vector<int> graph[MAX_N];

int main() {
	std::ios_base::sync_with_stdio(false);
	std::cin.tie(nullptr);

	int nodes;
	cin >> nodes;
	int left = nodes;
	for(int i = 0;i < nodes - 1;i ++) {
		int a, b;
		cin >> a >> b;
		a --;
		b --;
		conn[a] ++;
		conn[b] ++;
		graph[a].push_back(b);
		graph[b].push_back(a);
	}

	std::vector<int> q;
	for(int i = 0;i < nodes;i ++) {
		if(conn[i] == 1) q.push_back(i);
	}

	while(true) {
		//cout << "====" << endl;
		std::vector<int> nq;
		for(auto node : q) {
			left --;
			dead[node] = true;
			for(auto nei : graph[node]) {
				conn[nei] --;
				if(conn[nei] == 1) nq.push_back(nei);
			}
		}

		if(nq.size() == left) {
			cout << left << '\n';
			for(int i = 0;i < nodes;i ++) {
				if(!dead[i]) cout << i + 1 << ' ';
			}
			cout << '\n';
			break;
		}

		q = nq;
	}

}
