#include<iostream>
#include<vector>
using namespace std;

const int MAX_N = 100001;

vector<int> neighbours[MAX_N];
int currentBest[MAX_N];

int dfs(int previous, int current, int depth){
    int maxVal = 0;
    for(vector<int>::iterator it = neighbours[current].begin();
        it!=neighbours[current].end();it++){
            int next = (*it);
            if(next==previous)continue;

            int val = dfs(current,next,depth+1);
            if(maxVal<val)maxVal=val;
    }
    if(maxVal == 0)return depth;

    if(currentBest[current]<(maxVal-depth)){
        currentBest[current]=maxVal-depth;
    }

    return maxVal;
}

int main(){

    int n;
    cin>>n;
    for(int i=0;i<n-1;i++){
        int a,b;
        cin>>a>>b;
        neighbours[a].push_back(b);
        neighbours[b].push_back(a);
    }

    vector<int> checkNext;

    for(int i=1;i<=n;i++){
        currentBest[i]=0;
        if(neighbours[i].size()==1){
            checkNext.push_back(i);
        }
    }

    for(vector<int>::iterator it = checkNext.begin();it!=checkNext.end();it++){
        int current = (*it);
        dfs(0,current,0);
    }

    int minVal = INT_MAX;
    for(int i=1;i<=n;i++){
        if(currentBest[i]<minVal){
            minVal=currentBest[i];
        }
    }
    vector<int> answer;
    for(int i=1;i<=n;i++){
        if(currentBest[i]==minVal){
            answer.push_back(i);
        }
    }
    cout<<answer.size()<<endl;
    for(vector<int>::iterator it = answer.begin();it!=answer.end();it++){
        cout<<(*it);
        if(it+1!=answer.end())cout<<" ";
    }
    cout<<endl;
    return 0;
}