#include<iostream>
#include<vector>
using namespace std;

const int MAX_N = 100001;

vector<int> neighbours[MAX_N];
int currentBest[MAX_N];

int dfs(int previousVertex, int currentVertex, int depth){
    int maxVal = 0;
    for(vector<int>::iterator it = neighbours[currentVertex].begin();
        it!=neighbours[currentVertex].end();it++){
            int nextV = (*it);
            if(nextV==previousVertex)continue;

            int val = dfs(currentVertex,nextV,depth+1);
            if(maxVal<val)maxVal=val;
    }
    if(maxVal == 0)return depth;

    if(currentBest[currentVertex]<(maxVal-depth)){
        currentBest[currentVertex]=maxVal-depth;
    }

    return maxVal;
}

int main(){



    int n;
    cin>>n;
    for(int i=0;i<n-1;i++){
        int a,b;
        cin>>a>>b;
        neighbours[a].push_back(b);
        neighbours[b].push_back(a);
    }

    vector<int> checkNext;

    for(int i=1;i<=n;i++){
        currentBest[i]=0;
        if(neighbours[i].size()==1){
            checkNext.push_back(i);
        }
    }

    for(vector<int>::iterator it = checkNext.begin();it!=checkNext.end();it++){
        int currentVertex = (*it);
        dfs(0,currentVertex,0);
    }

    int minVal = MAX_N;
    for(int i=1;i<=n;i++){
        if(currentBest[i]<minVal){
            minVal=currentBest[i];
        }
    }
    vector<int> wantedAnswer;
    for(int i=1;i<=n;i++){
        if(currentBest[i]==minVal){
            wantedAnswer.push_back(i);
        }
    }
    cout<<wantedAnswer.size()<<endl;
    for(vector<int>::iterator it = wantedAnswer.begin();it!=wantedAnswer.end();it++){
        cout<<(*it);
        if(it+1!=wantedAnswer.end())cout<<" ";
    }
    cout<<endl;
    return 0;
}
