#include <iostream>
#include <vector>
#include <algorithm>
#include <queue>

std::vector<std::vector<int>> v;
std::queue<int> q;
std::vector<int> dist, dist2;

int main() {
    std::ios::sync_with_stdio(false);
    std::cin.tie(nullptr);
    int n;
    std::cin >> n;
    v.resize(n);
    dist.resize(n);
    for(int i = 0; i < n - 1; i++) {
        int a, b;
        std::cin >> a >> b;
        v[--a].push_back(--b);
        v[b].push_back(a);
    }
    q.push(0);
    int max = -1, d1 = -1, d2;
    while(!q.empty()) {
        auto sq = q.front();
        q.pop();
        for(auto &x: v[sq]) {
            if(!dist[x]) {
                dist[x] = dist[sq] + 1;
                q.push(x);
                if(dist[x] > max) {
                    max = dist[x];
                    d1 = x;
                }
            }
        }
    }
    dist.clear();
    dist.resize(n);
    q.push(d1);
    while(!q.empty()) {
        auto sq = q.front();
        q.pop();
        for(auto &x: v[sq]) {
            if(!dist[x]) {
                dist[x] = dist[sq] + 1;
                q.push(x);
                if(dist[x] > max) {
                    max = dist[x];
                    d2 = x;
                }
            }
        }
    }
    dist[d1] = 0;
    dist2.resize(n);
    q.push(d2);
    while(!q.empty()) {
        auto sq = q.front();
        q.pop();
        for(auto &x: v[sq]) {
            if(!dist2[x]) {
                dist2[x] = dist2[sq] + 1;
                q.push(x);
            }
        }
    }
    dist2[d2] = 0;
    std::vector<int> ans;
    std::vector<int> q;
    q.resize(n);
    int min = n + 1;
    for(int i = 0; i < n; i++) {
        q[i] = std::max(dist[i], dist2[i]);
        min  = std::min(q[i], min);
    }
    for(int i = 0; i < n; i++) {
        if(q[i] == min)
            ans.push_back(i + 1);
    }
    std::cout << ans.size() << std::endl;
    for(auto &x: ans) {
        std::cout << x << " ";
    }
    std::cout << std::endl;
    return 0;
}
