#include <iostream>
#include <queue>
#include <vector>

using namespace std;

const unsigned int maxn = (1<<17);

vector < unsigned int > ln [maxn];
bool visited [maxn];
unsigned int n;

unsigned int dfs (unsigned int start)
{
    for (unsigned int i = 0 ; i < n ; i ++)
        visited [i] = false;

    unsigned int depth = 0;
    queue < pair < unsigned int, unsigned int > > q;
    q.push ({start, 0});
    visited [start] = true;

    while (!q.empty ())
    {
        auto front = q.front(); q.pop();
        //cout << front.second << endl;
        depth = max (depth, front.second);
        for (auto next : ln [front.first])
        {
            if (!visited [next])
            {
                visited [next] = true;
                q.push({next, front.second + 1});
            }
        }
    }
    return depth;
}

int main ()
{
    cin.tie(nullptr);
    ios::sync_with_stdio(false);

    cin >> n;
    for (int i = 0 ; i < n - 1 ; i ++)
    {
        unsigned int a, b;
        cin >> a >> b;
        a --; b --;
        ln [a].push_back (b);
        ln [b].push_back (a);
    }
    unsigned int answer = 1e9;
    vector < unsigned int > answers;
    for (int i = 0 ; i < n ; i ++)
    {
        unsigned int current = dfs (i);
        if (current < answer )
        {
            answer = current;
            answers.clear();
            answers.push_back (i + 1);
        }
        else if (current == answer)
        {
            answers.push_back (i + 1);
        }
    }

    cout << answers.size () << endl;
    for (auto x : answers)
        cout << x << " ";
    cout << endl;
    return 0;
}

