#include <iostream>
#include <vector>
#include <cmath>

#define Asx A.start.x
#define Asy A.start.y
#define Bsx B.start.x
#define Bsy B.start.y
#define Aex A.end.x
#define Aey A.end.y
#define Bex B.end.x
#define Bey B.end.y

using namespace std;

template<typename _EuclideanRingElement> _EuclideanRingElement __gcd(_EuclideanRingElement __m, _EuclideanRingElement __n);

struct point
{
    int x, y;
    point (int a, int b) : x (a), y (b)
    { }
};

struct segment {
    point start, end;
    segment(point a, point b) : start(a), end (b)
    { }

    int deltaX () const
    {
        return (end.x - start.x) / __gcd(abs(end.x - start.x), abs(end.y - start.y));
    }

    int deltaY () const
    {
        return (end.y - start.y) / __gcd(abs(end.x - start.x), abs(end.y - start.y));
    }
};

vector < segment > segments; // 5000

int signed_area (point A, point B, point C)
{
    int area = (A.x + C.x) * (A.y - C.y) -
                (A.x + B.x) * (A.y - B.y) -
                (B.x + C.x) * (B.y - C.y);
    if (area < 0)
        return -1;
    else if (area == 0)
        return 0;
    else
        return 1;
}

int intersect (int i, int j)
{
    segment A = segments [i], B = segments [j];
    if (Asx == Bsx and Asy == Bsy and Aex == Bex and Aey == Bey) return 2;
    if (Asx == Bsx and Asy == Bsy) return 1;
    if ((B.deltaX()*A.deltaY() - B.deltaY()*A.deltaX()) == 0 or (B.deltaY()*A.deltaX()-A.deltaY()*B.deltaX()) == 0)
        return (Asx * A.deltaY() - A.deltaY() * Bsx - A.deltaX()*Asy + A.deltaX()*Bsy) == 0 and (Bsx*B.deltaY()-Asx*B.deltaY()-Bsy*B.deltaX()+Asy*B.deltaX()) == 0;
    int m = (Asx * A.deltaY() - A.deltaY() * Bsx - A.deltaX()*Asy + A.deltaX()*Bsy) / (B.deltaX()*A.deltaY() - B.deltaY()*A.deltaX());
    int mQ = abs(Asx * A.deltaY() - A.deltaY() * Bsx - A.deltaX()*Asy + A.deltaX()*Bsy) % abs(B.deltaX()*A.deltaY() - B.deltaY()*A.deltaX());
    int k = (Bsx*B.deltaY()-Asx*B.deltaY()-Bsy*B.deltaX()+Asy*B.deltaX())/(B.deltaY()*A.deltaX()-A.deltaY()*B.deltaX());
    int kQ = abs(Bsx*B.deltaY()-Asx*B.deltaY()-Bsy*B.deltaX()+Asy*B.deltaX())%abs(B.deltaY()*A.deltaX()-A.deltaY()*B.deltaX());
    if (mQ == 0 and kQ == 0 and m >= 0 and k >= 0) return 1;
    else return 0;
}

int main ()
{
    cin.tie(nullptr);
    ios::sync_with_stdio(false);

    int n;
    cin >> n;

    int answer = 0;

    for (int i = 0 ; i < n ; i ++)
    {
        short x1, y1, x2, y2;
        cin >> x1 >> y1 >> x2 >> y2;
        segments.push_back (segment {point (x1, y1),
                                     point (x2, y2)});
        answer += 1;
    }

    for (int i = 0 ; i < n ; i ++)
    {
        const auto& s = segments[i];
        //cout << abs(s.end.x - s.start.x) << " " << abs(s.end.y - s.start.y) << endl;
        answer += __gcd(abs(s.end.x - s.start.x), abs(s.end.y - s.start.y));
    }
    for (int i = 0 ; i < n ; i ++)
    for (int j = i + 1 ; j < n ; j ++)
        answer -= intersect(i, j);
    cout << answer << endl;
}

template<typename _EuclideanRingElement>
    _EuclideanRingElement
    __gcd(_EuclideanRingElement __m, _EuclideanRingElement __n)
    {
      while (__n != 0)
	{
	  _EuclideanRingElement __t = __m % __n;
	  __m = __n;
	  __n = __t;
	}
      return __m;
    }
